% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud.R
\name{cloudSyncCache}
\alias{cloudSyncCache}
\title{Sync cloud with local Cache}
\usage{
cloudSyncCache(cacheRepo = getOption("reproducible.cachePath")[1],
  checksumsFileID = NULL, cloudFolderID = NULL, delete = TRUE, ...)
}
\arguments{
\item{cacheRepo}{See \code{x} in \code{\link{showCache}}}

\item{checksumsFileID}{A google file ID where the checksums data.table is located,
provided as a character string.}

\item{cloudFolderID}{The google folder ID where a new checksums file should
 be written. This will only be used if \code{checksumsFileID} is not provided
provided as a character string.}

\item{delete}{Logical. If \code{TRUE}, the default, it will delete any objects
that are in \code{cloudFolderID} that are absent from local \code{cacheRepo}.
If \code{FALSE}, it will not delete objects.}

\item{...}{Arguments of \code{FUN} function .}
}
\description{
This is still experimental, see examples.
}
\details{
\code{cloudSyncCache} will remove any entries in a cloudCache that are not in a
}
\examples{
\dontrun{
  #make a google drive folder
  library(googledrive)
  newDir <- drive_mkdir("testFolder")
  a <- Cache(rnorm, 1)
  b <- Cache(rnorm, 2)

  # Will copy the 2 to the cloud
  cloudSyncCache(cloudFolderID = newDir$id)

  # remove a local one
  clearCache(userTags = CacheDigest(list(rnorm, 2))$outputHash, ask = FALSE)

  # Now will delete the object in the cloud that was just deleted locally
  cloudSyncCache(cloudFolderID = newDir$id)

  # clean up
  clearCache(ask = FALSE)
  cloudSyncCache(cloudFolderID = newDir$id)

  # To remove whole folder:
  drive_rm(as_id(newDir$id))
}
}
\seealso{
\code{\link{cloudCache}}, \code{\link{Cache}}, \code{\link{cloudWrite}},
  \code{\link{cloudCheck}}, \code{\link{cloudExtras}}
}
