% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud.R
\name{cloudUpload}
\alias{cloudUpload}
\title{Upload to cloud, if necessary}
\usage{
cloudUpload(isInRepo, outputHash, gdriveLs, cacheRepo, cloudFolderID,
  output)
}
\arguments{
\item{isInRepo}{A data.table with the information about an object that is in the local cacheRepo}

\item{outputHash}{The \code{cacheId} of the object to upload}

\item{gdriveLs}{The result of \code{googledrive::drive_ls(as_id(cloudFolderID), pattern = "outputHash")}}

\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{cloudFolderID}{A googledrive id of a folder, e.g., using \code{drive_mkdir()}. If
left as \code{NULL}, the function will create a cloud folder with a warning. The warning
will have the cloudFolderID that should be used in subsequent calls. It will also be
added to options("reproducible.cloudFolderID"), but this will not persist across sessions.}

\item{output}{The output object of FUN that was run in \code{Cache}}
}
\description{
Meant for internal use, as there are internal objects as arguments.
}
