% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPaths.R
\name{convertPaths}
\alias{convertPaths}
\alias{convertRasterPaths}
\title{Change the absolute path of a file}
\usage{
convertPaths(x, patterns, replacements)

convertRasterPaths(x, patterns, replacements)
}
\arguments{
\item{x}{For \code{convertPaths}, a character vector of file paths.
For \code{convertRasterPaths}, a disk-backed \code{RasterLayer}
object, or a list of such rasters.}

\item{patterns}{Character vector containing a pattern to match (see \code{?gsub}).}

\item{replacements}{Character vector of the same length of \code{patterns}
containing replacement text (see \code{?gsub}).}
}
\description{
\code{convertPaths} is simply a wrapper around \code{gsub} for changing the
first part of a path.
\code{convertRasterPaths} is useful for changing the path to a file-backed
raster (e.g., after copying the file to a new location).
}
\examples{
filenames <- c("/home/user1/Documents/file.txt", "/Users/user1/Documents/file.txt")
oldPaths <- dirname(filenames)
newPaths <- c("/home/user2/Desktop", "/Users/user2/Desktop")
convertPaths(filenames, oldPaths, newPaths)

r1 <- raster::raster(system.file("external/test.grd", package = "raster"))
r2 <- raster::raster(system.file("external/rlogo.grd", package = "raster"))
rasters <- list(r1, r2)
oldPaths <- system.file("external", package = "raster")
newPaths <- file.path("~/rasters")
rasters <- convertRasterPaths(rasters, oldPaths, newPaths)
lapply(rasters, raster::filename)

}
\author{
Eliot McIntire and Alex Chubaty
}
