% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checksums.R
\name{Checksums}
\alias{Checksums}
\alias{Checksums,character,logical-method}
\alias{Checksums,character,missing-method}
\title{Calculate checksum}
\usage{
Checksums(
  path,
  write,
  quickCheck = FALSE,
  checksumFile = identifyCHECKSUMStxtFile(path),
  files = NULL,
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\S4method{Checksums}{character,logical}(
  path,
  write,
  quickCheck = FALSE,
  checksumFile = identifyCHECKSUMStxtFile(path),
  files = NULL,
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\S4method{Checksums}{character,missing}(
  path,
  write,
  quickCheck = FALSE,
  checksumFile = identifyCHECKSUMStxtFile(path),
  files = NULL,
  verbose = getOption("reproducible.verbose", 1),
  ...
)
}
\arguments{
\item{path}{Character string giving the directory path containing \code{CHECKSUMS.txt}
file, or where it will be written if \code{checksumFile = TRUE}.}

\item{write}{Logical indicating whether to overwrite \code{CHECKSUMS.txt}.
Default is \code{FALSE}, as users should not change this file.
Module developers should write this file prior to distributing
their module code, and update accordingly when the data change.}

\item{quickCheck}{Logical. If \code{TRUE}, then this will only use file sizes,
rather than a digest::digest hash. This is generally faster,
but will be \emph{much} less robust.}

\item{checksumFile}{The filename of the checksums file to read or write to.
The default is \file{CHECKSUMS.txt} located at
\code{file.path(path, module, "data", checksumFile)}.
It is likely not a good idea to change this, and should
only be used in cases such as \code{Cache}, which can
evaluate if the \code{checksumFile} has changed.}

\item{files}{An optional character string or vector of specific files to checksum.
This may be very important if there are many files listed in a
\code{CHECKSUMS.txt} file, but only a few are to be checksummed.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{Passed to \code{\link[digest:digest]{digest::digest()}} and \code{\link[utils:write.table]{utils::write.table()}}.
For \code{digest}, the notable argument is \code{algo}. For \code{write.table},
the notable argument is \code{append}.}
}
\value{
A \code{data.table} with columns: \code{result}, \code{expectedFile},
\code{actualFile}, \code{checksum.x}, \code{checksum.y},
\code{algorithm.x}, \code{algorithm.y}, \code{filesize.x}, \code{filesize.y}
indicating the result of comparison between local file (\code{x}) and
expectation based on the \code{CHECKSUMS.txt} file.
}
\description{
Verify (and optionally write) checksums.
Checksums are computed using \code{\link[=.digest]{.digest()}}, which is simply a
wrapper around \code{digest::digest}.
}
\note{
In version 1.2.0 and earlier, two checksums per file were required
because of differences in the checksum hash values on Windows and Unix-like
platforms. Recent versions use a different (faster) algorithm and only require
one checksum value per file.
To update your \file{CHECKSUMS.txt} files using the new algorithm, see
\url{https://github.com/PredictiveEcology/SpaDES/issues/295#issuecomment-246513405}.
}
\examples{
\dontrun{
modulePath <- file.path(tempdir(), "myModulePath")
dir.create(modulePath, recursive = TRUE, showWarnings = FALSE)
moduleName <- "myModule"
cat("hi", file = file.path(modulePath, moduleName)) # put something there for this example

## verify checksums of all data files
Checksums(modulePath, files = moduleName)

## write new CHECKSUMS.txt file
Checksums(files = moduleName, modulePath, write = TRUE)
}

}
\author{
Alex Chubaty
}
