% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedMethods.R
\name{.wrap}
\alias{.wrap}
\alias{.wrap.list}
\alias{.wrap.environment}
\alias{.wrap.default}
\alias{.unwrap.default}
\alias{.unwrap}
\alias{.unwrap.environment}
\alias{.unwrap.list}
\title{Deal with class for saving to and loading from Cache or Disk}
\usage{
.wrap(
  obj,
  cachePath,
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  ...
)

\method{.wrap}{list}(
  obj,
  cachePath,
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  ...
)

\method{.wrap}{environment}(
  obj,
  cachePath,
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  ...
)

\method{.wrap}{default}(
  obj,
  cachePath,
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\method{.unwrap}{default}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

.unwrap(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{environment}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{list}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)
}
\arguments{
\item{obj}{Any arbitrary R object.}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{preDigest}{The list of \code{preDigest} that comes from \code{CacheDigest} of an object}

\item{drv}{if using a database backend, drv must be an object that
inherits from DBIDriver e.g., from package RSQLite, e.g., SQLite}

\item{conn}{an optional DBIConnection object, as returned by dbConnect().}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{outputObjects}{Optional character vector indicating which objects to
return. This is only relevant for list, environment (or similar) objects}

\item{...}{Arguments passed to methods; default does not use anything in \code{...}.}

\item{cacheId}{Used strictly for messaging. This should be the cacheId of the object being recovered.}
}
\value{
Returns an object that can be saved to disk e.g., via \code{saveRDS}.
}
\description{
This generic and some methods will do whatever is required to prepare an object for
saving to disk (or RAM) via e.g., \code{saveRDS}. Some objects (e.g., \code{terra}'s \verb{Spat*})
cannot be saved without first wrapping them. Also, file-backed objects are similar.
}
\examples{
# For SpatExtent
if (requireNamespace("terra")) {
  ex <- terra::ext(c(0, 2, 0, 3))
  exWrapped <- .wrap(ex)
  ex1 <- .unwrap(exWrapped)
}

}
