% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{saveToCache}
\alias{saveToCache}
\title{Save an object to Cache}
\usage{
saveToCache(
  cachePath = getOption("reproducible.cachePath"),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  obj,
  userTags,
  cacheId,
  linkToCacheId = NULL,
  verbose = getOption("reproducible.verbose")
)
}
\arguments{
\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{drv}{if using a database backend, drv must be an object that
inherits from DBIDriver e.g., from package RSQLite, e.g., SQLite}

\item{conn}{an optional DBIConnection object, as returned by dbConnect().}

\item{obj}{The R object to save to the cache}

\item{userTags}{A character vector with descriptions of the Cache function call. These
will be added to the Cache so that this entry in the Cache can be found using
\code{userTags} e.g., via \code{\link[=showCache]{showCache()}}.}

\item{cacheId}{The hash string representing the result of \code{.robustDigest}}

\item{linkToCacheId}{Optional. If a \code{cacheId} is provided here, then a \code{file.link}
will be made to the file with that \code{cacheId} name in the cache repo.
This is used when identical outputs exist in the cache. This will save disk space.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
This is used for its side effects, namely, it will add the object to the cache and
cache database.
}
\description{
This is not expected to be used by a user as it requires that the \code{cacheId} be
calculated in exactly the same as it calculated inside \code{Cache}
(which requires \code{match.call} to match arguments with their names, among other things).
}
