% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{formatters}
\alias{formatters}
\alias{format_json}
\alias{format_plain}
\alias{format_xml}
\alias{format_html}
\alias{format_table}
\title{Pre-supplied formatting generators}
\usage{
format_json(dataframe = "rows", matrix = "rowmajor", Date = "ISO8601",
  POSIXt = "string", factor = "string", complex = "string",
  raw = "base64", null = "list", na = "null", auto_unbox = FALSE,
  digits = 4, pretty = FALSE, force = FALSE)

format_plain(sep = "\\n")

format_xml(encoding = "UTF-8", options = "as_xml")

format_html(encoding = "UTF-8", options = "as_html")

format_table(...)
}
\arguments{
\item{dataframe}{how to encode data.frame objects: must be one of 'rows', 'columns' or 'values'}

\item{matrix}{how to encode matrices and higher dimensional arrays: must be one of 'rowmajor' or 'columnmajor'.}

\item{Date}{how to encode Date objects: must be one of 'ISO8601' or 'epoch'}

\item{POSIXt}{how to encode POSIXt (datetime) objects: must be one of 'string', 'ISO8601', 'epoch' or 'mongo'}

\item{factor}{how to encode factor objects: must be one of 'string' or 'integer'}

\item{complex}{how to encode complex numbers: must be one of 'string' or 'list'}

\item{raw}{how to encode raw objects: must be one of 'base64', 'hex' or 'mongo'}

\item{null}{how to encode NULL values within a list: must be one of 'null' or 'list'}

\item{na}{how to print NA values: must be one of 'null' or 'string'. Defaults are class specific}

\item{auto_unbox}{automatically \code{\link{unbox}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link{unbox}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{I()}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}

\item{digits}{max number of decimal digits to print for numeric values. Use \code{I()} to specify significant digits. Use \code{NA} for max precision.}

\item{pretty}{adds indentation whitespace to JSON output. Can be TRUE/FALSE or a number specifying the number of spaces to indent. See \code{\link{prettify}}}

\item{force}{unclass/skip objects of classes with no defined JSON mapping}

\item{sep}{The line separator. Plain text will be split into multiple strings
based on this.}

\item{encoding}{The character encoding to use in the document. The default
encoding is \sQuote{UTF-8}. Available encodings are specified at
\url{http://xmlsoft.org/html/libxml-encoding.html#xmlCharEncoding}.}

\item{options}{default: \sQuote{format}. Zero or more of
\describe{
  \item{format}{Format output}
  \item{no_declaration}{Drop the XML declaration}
  \item{no_empty_tags}{Remove empty tags}
  \item{no_xhtml}{Disable XHTML1 rules}
  \item{require_xhtml}{Force XHTML1 rules}
  \item{as_xml}{Force XML output}
  \item{as_html}{Force HTML output}
  \item{format_whitespace}{Format with non-significant whitespace}
}}

\item{...}{parameters passed on to \code{\link[=write.table]{write.table()}}}
}
\value{
A function accepting an R object
}
\description{
This set of functions can be used to construct formatting functions adhering
to the Response$format() requirements.
}
\examples{
fake_rook <- test <- fiery::fake_request(
  'http://example.com/test',
  content = '',
  headers = list(
    Content_Type = 'text/plain',
    Accept = 'application/json, text/csv'
  )
)

req <- Request$new(fake_rook)
res <- req$respond()
res$body <- mtcars
res$format(json = format_json(), csv = format_table(sep=','))
res$body

}
\seealso{
\link{parsers} for converting \code{Request} bodies into R objects

\link{default_formatters} for a list that maps the most common mime types
to their respective formatters
}
