% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sry_storage.R
\name{storage}
\alias{storage}
\title{Storage-Reliability-Yield (SRY) relationships: Storage computation}
\usage{
storage(Q, yield, reliability, profile = rep(1, frequency(Q)), plot = TRUE,
  S_initial = 1, max.iterations = 50, double_cycle = FALSE)
}
\arguments{
\item{Q}{the net inflows to the reservoir. This must be a time series object or vector of the net inflow volumes.}

\item{yield}{numerical.  (must be same volumetric unit as Q and R).}

\item{reliability}{numerical.  (must be same volumetric unit as Q and R).}

\item{profile}{a vector of factors with length = frequency(Q). Represents within-year demand profile. Defaults to constant release if left blank.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{max.iterations}{Maximum number of iterations for yield computation.}

\item{double_cycle}{logical. If TRUE the input series will be replicated and placed end-to-end to double the simulation. (Recommended if the critical period occurs at the end of the recorded inflow time series)}
}
\value{
Returns the required storage capacity necessary to supply specified yield with specified reliability.
}
\description{
Returns the required storage for given inflow time series, yield, and target time-based reliability. Assumes standard operating policy. Storage is computed iteratively using the bi-section method.
}
\examples{
# Determine the required storage for 95 \% reliability and yield equal to 80 \% of the mean inflow.
storage(ResX_inflow.ts, yield = 0.8*mean(ResX_inflow.ts), reliability = 0.95)
}

