% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_genpareto.R
\name{dist_genpareto}
\alias{dist_genpareto}
\alias{dist_genpareto1}
\title{Generalized Pareto Distribution}
\usage{
dist_genpareto(u = NULL, sigmau = NULL, xi = NULL)

dist_genpareto1(u = NULL, sigmau = NULL, xi = NULL)
}
\arguments{
\item{u}{Scalar location parameter, or \code{NULL} as a placeholder.}

\item{sigmau}{Scalar scale parameter, or \code{NULL} as a placeholder.}

\item{xi}{Scalar shape parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{GeneralizedParetoDistribution} object.
}
\description{
See \link[evmix:gpd]{evmix::gpd}
}
\details{
All parameters can be overridden with
\code{with_params = list(u = ..., sigmau = ..., xi = ...)}.

\code{dist_genpareto1} is equivalent to \code{dist_genpareto} but enforces
bound constraints on \code{xi} to \verb{[0, 1]}.
This ensures unboundedness and finite expected value unless \code{xi == 1.0}.
}
\examples{
d_genpareto <- dist_genpareto(u = 0, sigmau = 1, xi = 1)
x <- d_genpareto$sample(100)
d_emp <- dist_empirical(x)

d_genpareto$export_functions("gpd") # so fitdistrplus finds it

plot_distributions(
  empirical = d_emp,
  theoretical = d_genpareto,
  estimated = d_genpareto,
  with_params = list(
    estimated = fit(dist_genpareto(), x)$params
  ),
  .x = seq(0, 5, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
