test_that("obital speed computation works", {
  spec <- t(vapply(1:10, \(h) jonswap(h, tp = 12)$spec, FUN.VALUE = numeric(36)))
  orb_speed_bottom <- compute_orbital_speeds(spec,
    rscd_freq,
    depth = 50,
    z = 0
  )
  orb_speed_half <- compute_orbital_speeds(spec,
    rscd_freq,
    depth = 50,
    z = 25
  )
  orb_speed_top <- compute_orbital_speeds(spec,
    rscd_freq,
    depth = 50,
    z = 50
  )
  orb_speed_bottom_spec <- compute_orbital_speeds(
    spec,
    rscd_freq,
    depth = 50,
    z = 0,
    output_speeds = TRUE
  )
  expect_equal(dim(orb_speed_bottom), c(10, 2))
  expect_equal(dim(orb_speed_bottom_spec), c(10, 36, 2))
  expect_equal(orb_speed_bottom[, 2], rep(0, 10))
  expect_equal(orb_speed_bottom_spec[, , 2], matrix(0, ncol = 36, nrow = 10))
  expect_snapshot_value(orb_speed_bottom, style = "serialize")
  expect_snapshot_value(orb_speed_half, style = "serialize")
  expect_snapshot_value(orb_speed_top, style = "serialize")
})
