% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceResolver.R
\name{resolveResource}
\alias{resolveResource}
\title{Find a resource resolver}
\usage{
resolveResource(x)
}
\arguments{
\item{x}{The resource object which corresponding resolver is to be found.}
}
\value{
The corresponding ResourceResolver object or NULL if none applies.
}
\description{
Find the resolver that will make a client from the provided resource object.
}
\examples{
\donttest{
library(resourcer)
res <- newResource(
  name = "CNSIM1",
  url = "file:///data/CNSIM1.sav",
  format = "spss"
)
resolver <- resolveResource(res)
}

}
