% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{zeb_intermittent.rd}
\alias{zeb_intermittent.rd}
\title{Respirometry data of a zebrafish, \emph{Danio rerio}}
\format{
A data frame object consisting of 2 columns (time and dissolved
oxygen) and 79251 rows (approx 22h of data).
}
\usage{
zeb_intermittent.rd
}
\description{
Multiple measurements (106 replicates, plus initial and end background
measurements) of oxygen consumption in a zebrafish, \emph{Danio rerio}, obtained
using intermittent flow respirometry. Data kindly provided by Davide
Thambithurai (University of Glasgow). Note, the data has been injected with
random noise, and volume and mass below are not the actual values from the
experiment.
}
\details{
\itemize{
\item Dissolved oxygen units: \code{mg/L}
\item Time units: \code{seconds}
\item Chamber volume (L): \code{0.12}
\item Specimen wet mass (kg): `0.0009
\item Temperature (°C): \code{25}
\item Salinity: \code{0}
\item Atm. Pressure (bar): \code{1.013253}
}

Replicate structure (Rows - Experiment section):
\itemize{
\item \code{1:4999}      - Start background recording
\item \code{5000:5839}   - First replicate for MMR (14 mins duration)
\item \code{5840:75139}  - 105 further replicates of 11 minutes duration each (660 rows)
\item \code{75140:79251} - End background recording
}

Each replicate comprises a measurement period (12 minutes for replicate 1, 9
minutes for all others) plus 2 minutes flush.
}
\author{
Davide Thambithurai, University of Glasgow
}
\keyword{datasets}
