% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_plot.R
\name{rp.plot}
\alias{rp.plot}
\title{Plot an individual response}
\usage{
rp.plot(
  rp.object,
  obs = NULL,
  rowname = NULL,
  id = NULL,
  plot = TRUE,
  text.output = FALSE,
  groups = NULL,
  page.breaks = NULL,
  bw = FALSE
)
}
\arguments{
\item{rp.object}{A ResponsePatterns object.}

\item{obs}{An integer. The number of observation to plot.}

\item{rowname}{A string. The row name of the observation to plot.}

\item{id}{A string. The value of the ID variable (if defined in the ResponsePatterns object).}

\item{plot}{A logical scalar. Should the responses be plotted?}

\item{text.output}{A logical scalar. Should the responses be printed to the console?}

\item{groups}{A list of vectors. Defines groups of items that should be plotted using the same color.}

\item{page.breaks}{A vector. Draws a vertical line after the specified items (useful if you want to display the pagination of the questionnaire in the plot).}

\item{bw}{A logical scalar. Should the plot be printed in black and white?}
}
\value{
Plots a graph.
}
\description{
This function plots an individual response for easier visual inspection. The observation can be identified by one of the following methods: observation number (obs), row name (rowname), or the value of the ID variable (id, if defined in the rp.object). Only one of these identifiers should be specified. Using this function requires that the data are stored in the ResponsePatterns object.
}
\examples{
rp <- rp.acors(rp.simdata, id.var="optional_ID")
rp.plot(rp, obs=1)
rp.plot(rp, rowname="12", groups=list(c(1:10),c(11:20)))
rp.plot(rp, id="Natalya", page.breaks=c(5,10,15))
}
\seealso{
\code{\link{rp.acors}}, \code{\link{rp.patterns}}, \code{\link{rp.plots2pdf}}
}
