% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_table.R
\name{gen_table}
\alias{gen_table}
\title{Get the Data of a Table From GENESIS}
\usage{
gen_table(name, ...)
}
\arguments{
\item{name}{a string. Name of the table. Use of wildcards (\code{*}) allowed.}

\item{...}{Optional parameters passed on to the GENESIS API call:
\describe{
\item{\code{area}}{a string. The area in which the table is stored. Possible values:
\itemize{
\item \code{"public"}: table in the public catalogue
\item \code{"user"}: table in the user's account
}}
\item{\code{compress}}{a logical. Should empty rows and columns be discarded?}
\item{\code{transpose}}{a logical. Reshape the table between "wide" and
"long" format.}
\item{\code{startyear,endyear}}{a number. Only retrieve data between these years.}
\item{\code{regionalvariable}}{character. Code of the regional variable
whose value is specified in \code{regionalkey} to filter the results.}
\item{\code{regionalkey}}{character. One or more regional keys. Multiple
values can be supplied as a character vector or as a single string,
with the regional keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{classifyingvariable1,classifyingvariable2
      ,classifyingvariable3}}{character. Code of the subject classification
(SK-Merkmal) to which the selection by means of the corresponding
\code{classifyingkey} parameter is to be applied.}
\item{\code{classifyingkey1,classifyingkey2,classifyingkey3}}{character.
One or more values of a subject classification (e.g. "WZ93012"). Applied
to the corresponding \code{classifyingvariable} parameter. Multiple
keys can be supplied as a character vector or as a single string,
with the keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{stand}}{a string \code{"DD.MM.YYYY"}. Only retrieve data
updated after this #' date.}
\item{\code{language}}{Search terms, returned messages and data
descriptions in German (\code{"de"}) or English (\code{"en"})?}
}}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Download a table with data from GENESIS.
}
\examples{
\dontrun{
gen_table("21311-0001")
}

}
