% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_table.R
\name{gen_table}
\alias{gen_table}
\title{gen_table}
\usage{
gen_table(name, ...)
}
\arguments{
\item{name}{Character string. Name/code of the table. Use of wildcards (\code{*}) is possible.}

\item{...}{Optional parameters passed on to the Genesis API call:
\describe{
\item{\code{area}}{Character string. The area in which the table is stored. Possible values:
\itemize{
\item \code{"public"}: table in the public catalogue
\item \code{"user"}: table in the user's account
\item \code{"all"}: both of the above
}}
\item{\code{compress}}{Boolean. Should empty rows and columns be discarded?}
\item{\code{transpose}}{Boolean. Reshape the table between "wide" and
"long" format.}
\item{\code{startyear,endyear}}{Four-digit integers. Only retrieve data between these years.}
\item{\code{regionalvariable}}{Character string. Code of the regional variable
whose value is specified in \code{regionalkey} to filter the results.}
\item{\code{regionalkey}}{Character string. One or more regional keys. Multiple
values can be supplied as a character vector or as a single string,
with the regional keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{classifyingvariable1,classifyingvariable2
      ,classifyingvariable3}}{Character string. Code of the subject classification
(SK-Merkmal) to which the selection by means of the corresponding
\code{classifyingkey} parameter is to be applied.}
\item{\code{classifyingkey1,classifyingkey2,classifyingkey3}}{Character string.
One or more values of a subject classification (e.g. "WZ93012"). Applied
to the corresponding \code{classifyingvariable} parameter. Multiple
keys can be supplied as a character vector or as a single string,
with the keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{stand}}{Character string, format: \code{"DD.MM.YYYY"}. Only retrieve data
updated after this date.}
\item{\code{language}}{Search terms, returned messages and data
descriptions in German (\code{"de"}) or English (\code{"en"})?}
\item{\code{job}}{Boolean. Indicate as to whether a job should be created
(not available with the 'Zensus' database).)}
\item{\code{all_character}}{Boolean. Should all variables be imported as
'character' variables? Avoids fuzzy data type conversions if there are
leading zeros or other special characters. Defaults to TRUE.}
}}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Download a table with data from GENESIS, Zensus 2022 or regionalstatistik.de databases
}
\examples{
\dontrun{
gen_table("21311-0001")
}

}
