/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.ConnectivityFinder;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropSizeMinCC
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final IntVar sizeMinCC;
    private final ConnectivityFinder GLBCCFinder;
    private final ConnectivityFinder GUBCCFinder;

    public PropSizeMinCC(UndirectedGraphVar graph, IntVar sizeMinCC) {
        super(new Variable[]{graph, sizeMinCC}, (Priority)PropagatorPriority.QUADRATIC, false);
        this.g = graph;
        this.sizeMinCC = sizeMinCC;
        this.GLBCCFinder = new ConnectivityFinder((IGraph)this.g.getLB());
        this.GUBCCFinder = new ConnectivityFinder((IGraph)this.g.getUB());
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    private int getLBMinNCC(int nbNodesT, int nbNodesU) {
        if (nbNodesT == 0) {
            return 0;
        }
        if (nbNodesU > 0) {
            return 1;
        }
        return this.GLBCCFinder.getSizeMinCC();
    }

    private int getUBMinNCC(int nbNodesT) {
        if (nbNodesT > 0) {
            return this.getGUBMandatoryCCs().stream().mapToInt(cc -> this.GUBCCFinder.getSizeCC()[cc]).min().getAsInt();
        }
        return this.GUBCCFinder.getSizeMaxCC();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.GLBCCFinder.findAllCC();
        this.GUBCCFinder.findAllCC();
        int nbNodesT = this.g.getMandatoryNodes().size();
        int nbNodesTU = this.g.getPotentialNodes().size();
        int nbNodesU = nbNodesTU - nbNodesT;
        int minNCC_LB = this.getLBMinNCC(nbNodesT, nbNodesU);
        int minNCC_UB = this.getUBMinNCC(nbNodesT);
        if (this.sizeMinCC.getLB() > nbNodesTU) {
            this.fails();
        }
        if (minNCC_UB < this.sizeMinCC.getLB()) {
            this.fails();
        }
        if (minNCC_LB > this.sizeMinCC.getUB()) {
            this.fails();
        }
        this.sizeMinCC.updateLowerBound(minNCC_LB, this);
        this.sizeMinCC.updateUpperBound(minNCC_UB, this);
        for (int cc : this.getGUBOptionalCCs()) {
            if (this.GUBCCFinder.getSizeCC()[cc] >= this.sizeMinCC.getLB()) continue;
            int i = this.GUBCCFinder.getCCFirstNode()[cc];
            while (i != -1) {
                this.g.removeNode(i, this);
                i = this.GUBCCFinder.getCCNextNode()[i];
            }
        }
        boolean recomputeMinNCC_LB = false;
        Set<Integer> GUBMandatoryCCs = this.getGUBMandatoryCCs();
        if (minNCC_LB < this.sizeMinCC.getLB()) {
            for (int cc : GUBMandatoryCCs) {
                if (this.GUBCCFinder.getSizeCC()[cc] != this.sizeMinCC.getLB()) continue;
                int i = this.GUBCCFinder.getCCFirstNode()[cc];
                while (i != -1) {
                    this.g.enforceNode(i, this);
                    i = this.GUBCCFinder.getCCNextNode()[i];
                }
                this.sizeMinCC.instantiateTo(this.sizeMinCC.getLB(), this);
            }
            for (int cc = 0; cc < this.GLBCCFinder.getNBCC(); ++cc) {
                int i;
                Object outNeighbors;
                if (this.GLBCCFinder.getSizeCC()[cc] >= this.sizeMinCC.getLB()) continue;
                Map<Integer, Set<Integer>> ccPotentialNeighbors = this.getGLBCCPotentialNeighbors(cc);
                if (ccPotentialNeighbors.size() == 1 && (outNeighbors = ccPotentialNeighbors.get(i = ccPotentialNeighbors.keySet().iterator().next().intValue())).size() == 1) {
                    int j = (Integer)outNeighbors.iterator().next();
                    this.g.enforceNode(j, this);
                    this.g.enforceEdge(i, j, this);
                    recomputeMinNCC_LB = true;
                }
                if (ccPotentialNeighbors.size() <= 1) continue;
                HashSet outNeighbors2 = new HashSet();
                outNeighbors = ccPotentialNeighbors.values().iterator();
                while (outNeighbors.hasNext()) {
                    Set i2 = (Set)outNeighbors.next();
                    outNeighbors2.addAll(i2);
                }
                if (outNeighbors2.size() != 1) continue;
                int j = (Integer)outNeighbors2.iterator().next();
                this.g.enforceNode(j, this);
                recomputeMinNCC_LB = true;
            }
        }
        if (recomputeMinNCC_LB) {
            this.GLBCCFinder.findAllCC();
            nbNodesT = this.g.getMandatoryNodes().size();
            nbNodesU = nbNodesTU - nbNodesT;
            minNCC_LB = this.getLBMinNCC(nbNodesT, nbNodesU);
            if (minNCC_LB > this.sizeMinCC.getUB()) {
                this.fails();
            }
            if (this.sizeMinCC.getLB() < minNCC_LB) {
                this.sizeMinCC.updateLowerBound(minNCC_LB, this);
            }
        }
        if (minNCC_UB > this.sizeMinCC.getUB()) {
            if (this.sizeMinCC.getUB() == 0) {
                ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    this.g.removeNode(i, this);
                }
            }
            if (this.sizeMinCC.getUB() == 1 && nbNodesU == 1 && this.GLBCCFinder.getSizeMinCC() > 1) {
                ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    if (!((UndirectedGraph)this.g.getLB()).getNodes().contains(i)) continue;
                    this.g.enforceNode(i, this);
                    ISetIterator iSetIterator2 = this.g.getPotentialNeighborsOf(i).iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        if (i == j) continue;
                        this.g.removeEdge(i, j, this);
                    }
                    break block7;
                }
            }
        }
    }

    private Set<Integer> getGUBMandatoryCCs() {
        HashSet<Integer> mandatoryCCs = new HashSet<Integer>();
        block0: for (int cc = 0; cc < this.GUBCCFinder.getNBCC(); ++cc) {
            int i = this.GUBCCFinder.getCCFirstNode()[cc];
            while (i != -1) {
                if (((UndirectedGraph)this.g.getLB()).getNodes().contains(i)) {
                    mandatoryCCs.add(cc);
                    continue block0;
                }
                i = this.GUBCCFinder.getCCNextNode()[i];
            }
        }
        return mandatoryCCs;
    }

    private Set<Integer> getGUBOptionalCCs() {
        HashSet<Integer> optionalCCs = new HashSet<Integer>();
        for (int cc = 0; cc < this.GUBCCFinder.getNBCC(); ++cc) {
            int currentNode = this.GUBCCFinder.getCCFirstNode()[cc];
            boolean addCC = true;
            while (currentNode != -1) {
                if (((UndirectedGraph)this.g.getLB()).getNodes().contains(currentNode)) {
                    addCC = false;
                    break;
                }
                currentNode = this.GUBCCFinder.getCCNextNode()[currentNode];
            }
            if (!addCC) continue;
            optionalCCs.add(cc);
        }
        return optionalCCs;
    }

    private Set<Integer> getGLBCCNodes(int cc) {
        HashSet<Integer> ccNodes = new HashSet<Integer>();
        int i = this.GLBCCFinder.getCCFirstNode()[cc];
        while (i >= 0) {
            ccNodes.add(i);
            i = this.GLBCCFinder.getCCNextNode()[i];
        }
        return ccNodes;
    }

    private Map<Integer, Set<Integer>> getGLBCCPotentialNeighbors(int cc) {
        HashMap<Integer, Set<Integer>> ccPotentialNeighbors = new HashMap<Integer, Set<Integer>>();
        Set<Integer> ccNodes = this.getGLBCCNodes(cc);
        for (int i : ccNodes) {
            HashSet<Integer> outNeighbors = new HashSet<Integer>();
            ISetIterator iSetIterator = this.g.getPotentialNeighborsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (ccNodes.contains(j)) continue;
                outNeighbors.add(j);
            }
            if (outNeighbors.size() <= 0) continue;
            ccPotentialNeighbors.put(i, outNeighbors);
        }
        return ccPotentialNeighbors;
    }

    @Override
    public ESat isEntailed() {
        this.GLBCCFinder.findAllCC();
        this.GUBCCFinder.findAllCC();
        int nbNodesT = this.g.getMandatoryNodes().size();
        int nbNodesTU = this.g.getPotentialNodes().size();
        int nbNodesU = nbNodesTU - nbNodesT;
        int minNCC_LB = this.getLBMinNCC(nbNodesT, nbNodesU);
        int minNCC_UB = this.getUBMinNCC(nbNodesT);
        if (minNCC_UB < this.sizeMinCC.getLB() || minNCC_LB > this.sizeMinCC.getUB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            if (minNCC_LB == this.sizeMinCC.getValue()) {
                return ESat.TRUE;
            }
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

