/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.function.Consumer;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.AbstractObjManager;
import org.chocosolver.solver.variables.IntVar;

abstract class AbstractIntObjManager
extends AbstractObjManager<IntVar> {
    private static final long serialVersionUID = 5539060355541720114L;

    public AbstractIntObjManager(AbstractIntObjManager objman) {
        super(objman);
    }

    public AbstractIntObjManager(IntVar objective, ResolutionPolicy policy, Number precision) {
        super(objective, policy, precision);
        this.bestProvedLB = objective.getLB() - 1;
        this.bestProvedUB = objective.getUB() + 1;
    }

    @Override
    public synchronized boolean updateBestLB(Number lb) {
        if (this.bestProvedLB.intValue() < lb.intValue()) {
            this.bestProvedLB = lb;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean updateBestUB(Number ub) {
        if (this.bestProvedUB.intValue() > ub.intValue()) {
            this.bestProvedUB = ub;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBestSolution() {
        if (!((IntVar)this.objective).isInstantiated()) {
            throw new SolverException("objective variable (" + this.objective + ") is not instantiated on solution. Check constraints and/or decision variables.");
        }
        return this.updateBestSolution(((IntVar)this.objective).getValue());
    }

    @Override
    public void setStrictDynamicCut() {
        this.cutComputer = n -> n.intValue() + this.precision.intValue();
    }

    @Override
    public void resetBestBounds() {
        this.bestProvedLB = ((IntVar)this.objective).getLB() - 1;
        this.bestProvedUB = ((IntVar)this.objective).getUB() + 1;
    }

    public String toString() {
        return String.format("%s %s = %d", new Object[]{this.policy, this.objective == null ? "?" : ((IntVar)this.objective).getName(), this.getBestSolutionValue().intValue()});
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        action.accept((IntVar)this.objective);
    }
}

