% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.constraints.R
\name{sample_from_constraints}
\alias{sample_from_constraints}
\title{Sample from multivariate normal distribution under affine restrictions}
\usage{
sample_from_constraints(linear_part, offset, mean_param, covariance,
  initial_point, ndraw = 8000, burnin = 2000)
}
\arguments{
\item{linear_part}{r x d matrix for r restrictions and d dimension of Z}

\item{offset}{r-dim vector of offsets}

\item{mean_param}{d-dim mean vector of the unconditional normal}

\item{covariance}{d x d covariance matrix of unconditional normal}

\item{initial_point}{d-dim vector that initializes the sampler (must meet restrictions)}

\item{ndraw}{size of sample}

\item{burnin}{samples to throw away before storing}
}
\value{
Z ndraw x d matrix of samples
}
\description{
\code{sample_from_constraints} returns a sample from the conditional 
multivariate normal, restricted by affine constraints. 
The constraints are coded by a linear matrix and an offset vector:
\code{linear_part \%*\% Z <= offset.} 
The sampling uses a Gibbs sampler, and requires an initial vector 
that meets the restriction.
}
\examples{

# Compute conditional mean of correlated lower-truncated vector
 
constr = thresh2constraints(3, lower = c(1,1,1))
covariance = matrix(c(1,0.5,0,0.5,1,0.5,0,0.5,1),nc=3)
 
samp = sample_from_constraints(linear_part = constr$linear_part,
                                    offset= constr$offset,
                                    mean_param = c(0,0,0),
                                    covariance = covariance,
                                    initial_point = c(1.5,1.5,1.5), 
                                    ndraw=500,
                                    burnin=2000)


# all points should be >= 1 
any(samp<1)
colMeans(samp)

}

