% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squareFreeFactorization.R
\name{squareFreeFactorization}
\alias{squareFreeFactorization}
\title{Square-free factorization of a polynomial}
\usage{
squareFreeFactorization(qspray)
}
\arguments{
\item{qspray}{a \code{qspray} polynomial having at most nine variables}
}
\value{
A list with two fields \code{constantFactor} and
   \code{nonConstantFactors}. In the field \code{constantFactor}, there is
   a \code{bigq} rational number, the constant factor of the factorization.
   In the field \code{nonConstantFactors}, there is a list providing the
   square-free and pairwise coprime \code{qspray} polynomials of the
   factorization with their multiplicity.
}
\description{
Square-free factorization of a polynomial with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
p <- x^8*y^7 + 2*x^7*y^5 + x^6*y^4 + 2*x^5*y^2
squareFreeFactorization(p)
}
