% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SectionCreation.r
\name{generateMultipleListings}
\alias{generateMultipleListings}
\title{generateMultipleListings}
\usage{
generateMultipleListings(data, jobList, type = "Job", specialChars = "&")
}
\arguments{
\item{data}{data.frame holding the info for one job}

\item{jobList}{A list of jobs, each of which is a list where the first element is the Company, the second is the JobName and the third is a vector of BulletName's}

\item{type}{The type of section to build; defaults to 'Job', the other currently supported value is 'Research'}

\item{specialChars}{Vector of characters that need to be double-backslashed escaped}
}
\value{
A vector of text, one for each job
}
\description{
Generate an entire resume section
}
\details{
Using a list of lists to describe jobs generate text for each job subsection
}
\examples{
jobList <- list(
     list("Pied Piper", "Tech Startup", c(1, 3)),
     list("Goliath National Bank", "Bank Intern", 1:3),
     list("Surveyors Inc", "Survery Stats", 1:2)
)

generateMultipleListings(jobs, jobList)

}
\author{
Jared P. Lander
}
\seealso{
\code{link{generateListings}} \code{\link{generateSection}}
}

