% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{OutputParams}
\alias{OutputParams}
\title{Create OutputParams object}
\usage{
OutputParams(
  outputFilename = "simulationOutput.out",
  outputNumInitialDistance = 10,
  outputNumPairwiseDistance = 10,
  outputNumFamilyLabels = 10,
  outputNumFamilyMatrix = 10,
  outputMinSimilarity = 0.5
)
}
\arguments{
\item{outputFilename}{Where should the results of the simulation be saved? (This
can be parsed by input_file)}

\item{outputNumInitialDistance}{How many times across the simulation will we output the
distance of each sequence to the initial sequence}

\item{outputNumPairwiseDistance}{How many times across the simulation will we output the
pairwise distance between all pairs of sequences}

\item{outputNumFamilyLabels}{How many times across the simulation will we output
the representative sequences for each family?}

\item{outputNumFamilyMatrix}{How many times across the simulation will we output
the pairwise distances between family representatives?}

\item{outputMinSimilarity}{What is the minimum similarity between two sequences we should report on?}
}
\value{
A bundling of the parameters given to it as a SimulationParams object
}
\description{
Create OutputParams object
}
\examples{
outputParams <- OutputParams(outputFilename = 'myOutputFilename.out')
}
