% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rds.R
\name{read_rds}
\alias{read_rds}
\title{Read survey from rds file}
\usage{
read_rds(file, id = NULL, filename = NULL, doi = NULL)
}
\arguments{
\item{file}{A re-saved survey, imported with \code{haven::\link[haven:read_spss]{read_spss}}}

\item{id}{An identifier of the tibble, if omitted, defaults to the
file name.}

\item{filename}{An import file name.}

\item{doi}{An optional document object identifier.}
}
\value{
A tibble, data frame variant with survey attributes.
}
\description{
Read survey from rds file
}
\examples{
path <-  system.file("examples", "ZA7576.rds", package = "retroharmonize")
read_survey <- read_rds(path)
attr(read_survey, "id")
attr(read_survey, "filename")
attr(read_survey, "doi") 
}
\seealso{
Other import functions: 
\code{\link{pull_survey}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()},
\code{\link{subset_save_surveys}()}
}
\concept{import functions}
