% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_var_names.R
\name{suggest_var_names}
\alias{suggest_var_names}
\title{Suggest Variable Names

The function harmonizes the variable names of surveys (of class \code{survey}) that 
are imported from an external file as a wave.}
\usage{
suggest_var_names(
  metadata,
  permanent_names = NULL,
  survey_program = NULL,
  case = "snake"
)
}
\arguments{
\item{metadata}{A metadata table created by \code{metadata_create} and binded together for 
all surveys in \code{waves}.}

\item{permanent_names}{A character vector of names to keep.}

\item{survey_program}{If \code{permanent_names = NULL} then \code{\link{suggest_permanent_names}} is 
called with this parameter, unless it is also \code{NULL}}

\item{case}{Unless it is set to \code{NULL} it will standardize the suggested variable name with 
\code{\link[snakecase]{to_any_case}}. The default is \code{"snake"}.}
}
\value{
A \code{metadata} tibble augmented with $var_name_suggested
}
\description{
Suggest Variable Names

The function harmonizes the variable names of surveys (of class \code{survey}) that 
are imported from an external file as a wave.
}
\examples{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path(examples_dir, survey_list), 
  save_to_rds = FALSE)
metadata <- lapply ( X = example_surveys, FUN = metadata_create )
metadata <- do.call(rbind, metadata)

utils::head(
  suggest_var_names(metadata, survey_program = "eurobarometer" )
  )
}
\seealso{
Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{harmonize_waves}()},
\code{\link{label_normalize}()},
\code{\link{merge_waves}()},
\code{\link{na_range_to_values}()},
\code{\link{suggest_permanent_names}()}
}
\concept{harmonization functions}
