% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps.R
\name{kgaps_stats}
\alias{kgaps_stats}
\title{Sufficient statistics for the K-gaps model}
\usage{
kgaps_stats(data, thresh, k = 1, inc_cens = FALSE)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{thresh}{A numeric scalar.  Extreme value threshold applied to data.}

\item{k}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = max(T - K, 0)}.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times relating to the
first and last observation.  See Attalides (2015) for details.}
}
\value{
A list containing the sufficient statistics, with components
  \itemize{
    \item {\code{N0} : } {the number of zero K-gaps}
    \item {\code{N1} : } {contribution from non-zero K-gaps (see
      \strong{Details})}
    \item {\code{sum_qs} : } {the sum of the (scaled) K-gaps, i.e.
      \eqn{q (S_0 + ... + S_N)}, where \eqn{q} is estimated by the
      proportion of threshold exceedances.}
  }
}
\description{
Calculates sufficient statistics for the K-gaps model for the extremal index
\eqn{\theta}.
}
\details{
The sample K-gaps are \eqn{S_0, S_1, ..., S_(N-1),
  S_N}, where \eqn{S_1, ..., S_(N-1)} are uncensored and \eqn{S_0} and
  \eqn{S_N} are censored.  Under the assumption that the K-gaps are
  independent, the log-likelihood of the K-gaps model is given by
  \deqn{l(\theta; S_0, ..., S_N) = N_0 log(1 - \theta) + 2 N_1 log \theta -
    \theta q (S_0 + ... + S_N),}
   where \eqn{q} is the threshold exceedance probability,
   \eqn{N_0} is the number of sample K-gaps that are equal to zero and
   (apart from an adjustment for the contributions of \eqn{S_0} and
   \eqn{S_N}) \eqn{N_1} is the number of positive sample K-gaps.
   Specifically, \eqn{N_1} is equal to the number of \eqn{S_1, ..., S_(N-1)}
   that are positive plus \eqn{(I_0 + I_N) / 2}, where \eqn{I_0 = 1} if
   \eqn{S_0} is greater than zero and similarly for \eqn{I_N}.
   The differing treatment of uncensored and censored K-gaps reflects
   differing contributions to the likelihood.
   For full details see Suveges and Davison (2010) and Attalides (2015).
}
\examples{
u <- quantile(newlyn, probs = 0.90)
kgaps_stats(newlyn, u)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{http://dx.doi.org/10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{http://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{kgaps_mle}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the K-gaps model.
}
