% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gp_flatflat}
\alias{gp_flatflat}
\title{Flat prior for GP parameters (\eqn{\sigma, \xi})}
\usage{
gp_flatflat(pars, min_xi = -Inf, max_xi = Inf, trendsd = 0, upper = NULL)
}
\arguments{
\item{pars}{A numeric vector of length 2.
GP parameters (\eqn{\sigma, \xi}).}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.
Must not be \code{-Inf} because this results in an improper posterior.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatibility with
function in the evdbayes package.}

\item{upper}{A positive numeric scalar.  The upper endpoint of the GP
distribution.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
