% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{print.summary.evpost}
\alias{print.summary.evpost}
\title{Print method for objects of class "summary.evpost"}
\usage{
\method{print}{summary.evpost}(x, ...)
}
\arguments{
\item{x}{An object of class "summary.evpost", a result of a call to
\code{\link{summary.evpost}}.}

\item{...}{Additional arguments passed on to \code{print}.}
}
\value{
Prints
\itemize{
  \item {information about the ratio-of-uniforms bounding box, i.e.
    \code{object$box}}
  \item {an estimate of the probability of acceptance, i.e.
    \code{object$pa}}
  \item {a summary of the simulated values, via
    \code{summary(object$sim_vals)}}
}
}
\description{
\code{print} method for an object \code{object} of class "summary.evpost".
}
\examples{
# GP posterior
u <- stats::quantile(gom, probs = 0.65)
fp <- set_prior(prior = "flat", model = "gp", min_xi = -1)
gpg <- rpost_rcpp(n = 1000, model = "gp", prior = fp, thresh = u,
                  data = gom)
summary(gpg)
}
\seealso{
\code{\link[rust]{ru}} or \code{\link[rust]{ru_rcpp}} for
  descriptions of \code{object$sim_vals} and \code{$box}.

\code{\link{plot.evpost}} for a diagnostic plot.
}
