% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf.partial.prob.R
\name{rf.partial.prob}
\alias{rf.partial.prob}
\title{Random Forest probability scaled partial dependency plots}
\usage{
rf.partial.prob(x, pred.data, xname, which.class, w, prob = TRUE,
  plot = TRUE, smooth = FALSE, raw = FALSE, rug = FALSE, n.pt, xlab,
  ylab, main, ...)
}
\arguments{
\item{x}{Object of class randomForest}

\item{pred.data}{Training data.frame used for constructing the plot,}

\item{xname}{Name of the variable for calculating partial dependence}

\item{which.class}{The class to focus on}

\item{w}{Weights to be used in averaging (if not supplied, mean is not weighted)}

\item{prob}{Scale distances to probabilities}

\item{plot}{Plot results (TRUE/FALSE)}

\item{smooth}{Apply spline.smooth to y}

\item{raw}{Plot unsmoothed values}

\item{rug}{Draw hash marks on plot representing deciles of x}

\item{n.pt}{Number of points on the grid for evaluating partial dependence.}

\item{xlab}{x-axis plot label}

\item{ylab}{y-axis plot label}

\item{main}{Plot label for main}

\item{...}{Additional graphical parameters passed to plot}
}
\value{
A list class object with fit x,y. If smooth=TRUE y represents smoothed scaled margin distance values
}
\description{
Produces partial dependency plots with probability distribution based on scaled margin distances.
}
\examples{
require(randomForest)
  data(iris)
    iris.rf <- randomForest(iris[,1:4], iris[,5])
      par(mfrow=c(2,2))
        for(i in names(iris)[1:4]) {     
          rf.partial.prob(iris.rf, iris, i, "setosa", smooth=TRUE, raw=TRUE, rug=FALSE)
         }

}
\references{
Evans J.S., M.A. Murphy, Z.A. Holden, S.A. Cushman (2011). Modeling species distribution and change using Random Forests CH.8 in Predictive Modeling in Landscape Ecology eds Drew, CA, Huettmann F, Wiersma Y. Springer

Baruch-Mordo, S., J.S. Evans, J. Severson, J. D. Naugle, J. Kiesecker, J. Maestas, & M.J. Falkowski (2013) Saving sage-grouse from the trees: A proactive solution to reducing a key threat to a candidate species Biological Conservation 167:233-241
}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
