% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapters-auto.R
\name{ch03}
\alias{ch03}
\alias{ch3}
\title{Print examples of chapter 3 of 'R for Dummies'.}
\usage{
ch03()

ch3()
}
\description{
To print a listing of all examples of a chapter, use \code{ch3()}. To run all the examples of \code{ch3()}, use \code{example(ch3)}.
}
\examples{
# Chapter 3 - The Fundamentals of R

# Using the Full Power of Functions

## Vectorizing your functions

baskets.of.Granny <- c(12,4,4,6,9,3)
baskets.of.Granny
sum(baskets.of.Granny)

firstnames <- c("Joris", "Carolien", "Koen")
lastname <- "Meys"
paste(firstnames,lastname)

authors <- c("Andrie","Joris")
lastnames <- c("de Vries","Meys")
paste(authors,lastnames)

## Putting the argument in a function

# print() ### This line of code leads to deliberate error for illustration
print(x = "Isn't this fun?")

print(digits=4, x = 11/7)

# Making history

\dontrun{
savehistory(file = "Chapter3.Rhistory")
}
\dontrun{
loadhistory("Chapter3.Rhistory")
}

# Keeping Your Code Readable

## Following naming conventions

## Choosing a clear name

paste <- paste("This gets","confusing")
paste
paste("Don't","you","think?")

## Choosing a naming style

## Structuring your code

baskets.of.Geraldine <- c(5,3,2,2,12,9)
Intro <- "It is amazing! The All Star Grannies scored
a total of"

Outro <- "baskets in the last six games!"

Total.baskets <- baskets.of.Granny +
               baskets.of.Geraldine

Text <- paste(Intro,
              sum(Total.baskets),
              Outro)
cat(Text)
Text

cat('If you doubt whether it works,
+ just try it out.')

## Adding comments

# The All Star Grannies do it again!
baskets.of.Granny <- c(12,4,4,6,9,3) # Granny rules
sum(baskets.of.Granny) # total number of points


# Getting from Base R to More

## Finding packages

## Installing packages

\dontrun{
install.packages("fortunes")
}

library("fortunes")
fortune("This is R")
fortune(161)
detach(package:fortunes)

}
\seealso{
\code{\link{toc}}

Other Chapters: \code{\link{ch01}}, \code{\link{ch02}},
  \code{\link{ch04}}, \code{\link{ch05}},
  \code{\link{ch06}}, \code{\link{ch07}},
  \code{\link{ch08}}, \code{\link{ch09}},
  \code{\link{ch10}}, \code{\link{ch11}},
  \code{\link{ch12}}, \code{\link{ch13}},
  \code{\link{ch14}}, \code{\link{ch15}},
  \code{\link{ch16}}, \code{\link{ch17}},
  \code{\link{ch18}}, \code{\link{ch19}},
  \code{\link{ch20}}
}

