% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapters-auto.R
\name{ch02}
\alias{ch02}
\alias{ch2}
\title{Print examples of chapter 2 of 'R for Dummies'.}
\usage{
ch02()

ch2()
}
\description{
To print a listing of all examples of a chapter, use \code{ch2()}.
To run all the examples of \code{ch2()}, use \code{example(ch2)}.
}
\examples{
# Chapter 2 - Exploring R

# Working with a Code Editor

## Exploring RGui

### Seeing the naked R console


### Issuing a simple command

24+7+11

### Closing the console

\dontrun{
quit()
}


## Dressing up with RStudio


# Starting Your First R Session

## Saying hello to the world

print("Hello world!")

## Doing simple math

1+2+3+4+5

## Using vectors


c(1,2,3,4,5)
1:5
sum(1:5)

## Storing and calculating values

x <- 1:5
x

y <- 10
x + y

x
y

z <- x + y
z

h <- "Hello"
h

hw <- c("Hello", "world!")
hw

paste("Hello", "world!")

## Talking back to the user

h <- "Hello"
if(interactive()){
yourname <- readline("What is your name?")
} else {
  yourname <- "Joris"
}
paste(h, yourname)

# Sourcing a Script

h <- "Hello"
yourname <- readline("What is your name?")
print(paste(h, yourname))


### Finding help on functions
?paste
help(paste)

# Navigating the Workspace
ls()

## Manipulating the content of the workspace

rm(z)
ls()

##Saving your work

getwd()

filename <- file.path(tempdir(), "yourname.rda")
\dontrun{
save(yourname, file=filename)
}
list.files(tempdir(), pattern = ".rda")

## Retrieving your work


rm(yourname)
\dontrun{
load("yourname.rda")
}

}
\seealso{
\code{\link{toc}}

Other Chapters: 
\code{\link{ch01}()},
\code{\link{ch03}()},
\code{\link{ch04}()},
\code{\link{ch05}()},
\code{\link{ch06}()},
\code{\link{ch07}()},
\code{\link{ch08}()},
\code{\link{ch09}()},
\code{\link{ch10}()},
\code{\link{ch11}()},
\code{\link{ch12}()},
\code{\link{ch13}()},
\code{\link{ch14}()},
\code{\link{ch15}()},
\code{\link{ch16}()},
\code{\link{ch17}()},
\code{\link{ch18}()},
\code{\link{ch19}()},
\code{\link{ch20}()}
}
\concept{Chapters}
