% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/parsenames.R
\name{parsenames}
\alias{parsenames}
\title{Parse taxon names using the GBIF name parser.}
\usage{
parsenames(scientificname, ...)
}
\arguments{
\item{scientificname}{A character vector of scientific names.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will be
combined with \code{\link[httr]{config}}.}
}
\value{
A \code{data.frame} containing fields extracted from parsed
taxon names. Fields returned are the union of fields extracted from
all species names in \code{scientificname}.
}
\description{
Parse taxon names using the GBIF name parser.
}
\examples{
\dontrun{
parsenames(scientificname='x Agropogon littoralis')
parsenames(c('Arrhenatherum elatius var. elatius',
             'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
             'Vanessa atalanta (Linnaeus, 1758)'))

# Pass on options to httr
library('httr')
res <- parsenames(c('Arrhenatherum elatius var. elatius',
             'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
             'Vanessa atalanta (Linnaeus, 1758)'), config=progress())
}
}
\author{
John Baumgartner (johnbb@student.unimelb.edu.au)
}
\references{
\url{http://www.gbif.org/developer/species#parser}
}

