% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_metadata.r
\name{occ_metadata}
\alias{occ_metadata}
\title{Search for catalog numbers, collection codes, collector names, and
institution codes.}
\usage{
occ_metadata(
  type = "catalogNumber",
  q = NULL,
  limit = 5,
  pretty = TRUE,
  curlopts = list()
)
}
\arguments{
\item{type}{Type of data, one of catalogNumber, collectionCode, recordedBy,
or institutionCode. Unique partial strings work too, like 'cat' for
catalogNumber}

\item{q}{Search term}

\item{limit}{Number of results, default=5}

\item{pretty}{Pretty as true (Default) uses cat to print data, \code{FALSE} gives
character strings.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\description{
Search for catalog numbers, collection codes, collector names, and
institution codes.
}
\examples{
\dontrun{
# catalog number
occ_metadata(type = "catalogNumber", q=122)

# collection code
occ_metadata(type = "collectionCode", q=12)

# institution code
occ_metadata(type = "institutionCode", q='GB')

# recorded by
occ_metadata(type = "recordedBy", q='scott')

# data as character strings
occ_metadata(type = "catalogNumber", q=122, pretty=FALSE)

# Change number of results returned
occ_metadata(type = "catalogNumber", q=122, limit=10)

# Partial unique type strings work too
occ_metadata(type = "cat", q=122)

# Pass on curl options
occ_metadata(type = "cat", q=122, curlopts = list(verbose = TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/occurrence#search}
}
