% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads.R
\name{downloads}
\alias{downloads}
\title{Downloads interface}
\description{
GBIF provides two ways to get occurrence data: through the
\verb{/occurrence/search} route (see \code{\link[=occ_search]{occ_search()}}),
or via the \verb{/occurrence/download} route (many functions, see below).
\code{\link[=occ_search]{occ_search()}} is more appropriate for smaller data, while
\verb{occ_download*()} functions are more appropriate for larger data requests.
}
\section{Settings}{

You'll use \code{\link[=occ_download]{occ_download()}} to kick off a download. You'll need to
give that function settings from your GBIF profile: your user name, your
password, and your email. These three settings are required to use the
function. You can specify them in one of three ways:
\itemize{
\item Pass them to \code{occ_download} as parameters
\item Use R options: As options either in the current R session using
the \code{\link[=options]{options()}} function, or by setting them in your \code{.Rprofile} file, after
which point they'll be read in automatically
\item Use environment variables: As env vars either in the current R session using
the \code{\link[=Sys.setenv]{Sys.setenv()}} function, or by setting them in your
\code{.Renviron}/\code{.bash_profile} or similar files, after which point they'll be read
in automatically
}
}

\section{BEWARE}{

You can not perform that many downloads, so plan wisely.
See \emph{Rate limiting} below.
}

\section{Rate limiting}{

If you try to launch too many downloads, you will receive an 420
"Enhance Your Calm" response. If there is less then 100 in total
across all GBIF users, then you can have 3 running at a time. If
there are more than that, then each user is limited to 1 only.
These numbers are subject to change.
}

\section{Functions}{

\itemize{
\item \code{\link[=occ_download]{occ_download()}} - Start a download
\item \code{\link[=occ_download_prep]{occ_download_prep()}} - Prepare a download request
\item \code{\link[=occ_download_queue]{occ_download_queue()}} - Start many downloads in a queue
\item \code{\link[=occ_download_wait]{occ_download_wait()}} - Re-run \code{occ_download_meta()} until ready
\item \code{\link[=occ_download_meta]{occ_download_meta()}} - Get metadata progress on a single download
\item \code{\link[=occ_download_list]{occ_download_list()}} - List your downloads
\item \code{\link[=occ_download_cancel]{occ_download_cancel()}} - Cancel a download
\item \code{\link[=occ_download_cancel_staged]{occ_download_cancel_staged()}} - Cancels any jobs with status \code{RUNNING}
or \code{PREPARING}
\item \code{\link[=occ_download_get]{occ_download_get()}} - Retrieve a download
\item \code{\link[=occ_download_import]{occ_download_import()}} - Import a download from local file system
\item \code{\link[=occ_download_datasets]{occ_download_datasets()}} - List datasets for a download
\item \code{\link[=occ_download_dataset_activity]{occ_download_dataset_activity()}} - Lists the downloads activity
of a dataset
}

Download query composer methods:

See \link{download_predicate_dsl}
}

\section{Query length}{

GBIF has a limit of 12,000 characters for a download query. This means
that you can have a pretty long query, but at some point it may lead to an
error on GBIF's side and you'll have to split your query into a few.
}

\section{Download status}{

The following statuses can be found with any download:
\itemize{
\item PREPARING: just submitted by user and awaiting processing (typically only
a few seconds)
\item RUNNING: being created (takes typically 1-15 minutes)
\item FAILED: something unexpected went wrong
\item KILLED: user decided to abort the job while it was in PREPARING or RUNNING
phase
\item SUCCEEDED: The download was created and the user was informed
\item FILE_ERASED: The download was deleted according to the retention policy,
see https://www.gbif.org/faq?question=for-how-long-will-does-gbif-store-downloads
}
}

