% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_predicate_dsl.R
\name{download_predicate_dsl}
\alias{download_predicate_dsl}
\alias{pred}
\alias{pred_gt}
\alias{pred_gte}
\alias{pred_lt}
\alias{pred_lte}
\alias{pred_not}
\alias{pred_like}
\alias{pred_within}
\alias{pred_notnull}
\alias{pred_or}
\alias{pred_and}
\alias{pred_in}
\title{Download predicate DSL (domain specific language)}
\usage{
pred(key, value)

pred_gt(key, value)

pred_gte(key, value)

pred_lt(key, value)

pred_lte(key, value)

pred_not(key, value)

pred_like(key, value)

pred_within(value)

pred_notnull(key)

pred_or(..., .list = list())

pred_and(..., .list = list())

pred_in(key, value)
}
\arguments{
\item{key}{(character) the key for the predicate. See "Keys" below}

\item{value}{(various) the value for the predicate}

\item{..., .list}{For \code{pred_or()} or \code{pred_and()}, one or more objects of
class \code{occ_predicate}, created by any \verb{pred*} function}
}
\description{
Download predicate DSL (domain specific language)
}
\section{predicate methods and their equivalent types}{


\verb{pred*} functions are named for the 'type' of operation they do, following
the terminology used by GBIF, see
https://www.gbif.org/developer/occurrence#predicates

Function names are given, with the equivalent GBIF type value (e.g.,
\code{pred_gt} and \code{greaterThan})

The following functions take one key and one value:
\itemize{
\item \code{pred}: equals
\item \code{pred_lt}: lessThan
\item \code{pred_lte}: lessThanOrEquals
\item \code{pred_gt}: greaterThan
\item \code{pred_gte}: greaterThanOrEquals
\item \code{pred_not}: not
\item \code{pred_like}: like
}

The following function is only for geospatial queries, and only
accepts a WKT string:
\itemize{
\item \code{pred_within}: within
}

The following function is only for stating the you don't want
a key to be null, so only accepts one key:
\itemize{
\item \code{pred_notnull}: isNotNull
}

The following two functions accept multiple individual predicates,
separating them by either "and" or "or":
\itemize{
\item \code{pred_and}: and
\item \code{pred_or}: or
}

The following function is special in that it accepts a single key
but many values; stating that you want to search for all the values:
\itemize{
\item \code{pred_in}: in
}
}

\section{What happens internally}{

Internally, the input to \verb{pred*} functions turns into JSON to be sent to
GBIF. For example ...

\code{pred_in("taxonKey", c(2480946, 5229208))} gives:\preformatted{\{
   "type": "in",
   "key": "TAXON_KEY",
   "values": ["2480946", "5229208"]
 \}
}

\code{pred_gt("elevation", 5000)} gives:\preformatted{\{
   "type": "greaterThan",
   "key": "ELEVATION",
   "value": "5000"
\}
}

\code{pred_or(pred("taxonKey", 2977832), pred("taxonKey", 2977901))} gives:\preformatted{\{
  "type": "or",
  "predicates": [
     \{
       "type": "equals",
       "key": "TAXON_KEY",
       "value": "2977832"
     \},
     \{
       "type": "equals",
       "key": "TAXON_KEY",
       "value": "2977901"
     \}
  ]
\}
}
}

\section{Keys}{


Acceptable arguments to the \code{key} parameter are (with the version of
the key in parens that must be sent if you pass the query via the \code{body}
parameter; see below for examples):
\itemize{
\item taxonKey (TAXON_KEY)
\item scientificName (SCIENTIFIC_NAME)
\item country (COUNTRY)
\item publishingCountry (PUBLISHING_COUNTRY)
\item hasCoordinate (HAS_COORDINATE)
\item hasGeospatialIssue (HAS_GEOSPATIAL_ISSUE)
\item typeStatus (TYPE_STATUS)
\item recordNumber (RECORD_NUMBER)
\item lastInterpreted (LAST_INTERPRETED)
\item continent (CONTINENT)
\item geometry (GEOMETRY)
\item basisOfRecord (BASIS_OF_RECORD)
\item datasetKey (DATASET_KEY)
\item eventDate (EVENT_DATE)
\item catalogNumber (CATALOG_NUMBER)
\item year (YEAR)
\item month (MONTH)
\item decimalLatitude (DECIMAL_LATITUDE)
\item decimalLongitude (DECIMAL_LONGITUDE)
\item elevation (ELEVATION)
\item depth (DEPTH)
\item institutionCode (INSTITUTION_CODE)
\item collectionCode (COLLECTION_CODE)
\item issue (ISSUE)
\item mediatype (MEDIA_TYPE)
\item recordedBy (RECORDED_BY)
}
}

\examples{
pred("taxonKey", 3119195)
pred_gt("elevation", 5000)
pred_gte("elevation", 5000)
pred_lt("elevation", 1000)
pred_lte("elevation", 1000)
pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))")
pred_and(pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))"),
  pred_gte("elevation", 5000))
pred_or(pred_lte("year", 1989), pred("year", 2000))
pred_and(pred_lte("year", 1989), pred("year", 2000))
pred_in("taxonKey", c(2977832, 2977901, 2977966, 2977835))
pred_in("basisOfRecord", c("MACHINE_OBSERVATION", "HUMAN_OBSERVATION"))
pred_not("catalogNumber", "cat1")
pred_like("catalogNumber", "PAPS5-560\%")
pred_notnull("issue")
pred("basisOfRecord", "LITERATURE")
pred("hasCoordinate", TRUE)
pred("hasGeospatialIssue", FALSE)
pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))")
pred_or(pred("taxonKey", 2977832), pred("taxonKey", 2977901),
  pred("taxonKey", 2977966))
pred_in("taxonKey", c(2977832, 2977901, 2977966, 2977835))
}
\references{
Download predicates docs:
\url{https://www.gbif.org/developer/occurrence#predicates}
}
\seealso{
Other downloads: 
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
