#' Cancel Pending Order(s)
#'
#' @name cancel_order
#'
#' @description This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The users can cancel all orders at this time.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return  TBD
#' @examples
#' \dontrun{
#' cancel_order(api.key = your_key,
#'              secret = your_api_secret,
#'              passphrase = your_api_pass)
#' }
#'
#' @export

cancel_order <- function(api.key,
                         secret,
                         passphrase) {
  #get url extension----
  req.url <- "/orders/"

  #define method----
  method = "DELETE"

  #fetch response----
  response <-
    auth(
      method = method,
      req.url = req.url,
      api.key = api.key,
      secret = secret,
      passphrase = passphrase
    )

  #transform----
  response <- as.data.frame(response)

  #return----
  return(response)
}
