% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth}
\alias{auth}
\title{Parse Authenticated Calls To GDAX API}
\usage{
auth(method, req.url, api.key, secret, passphrase, order = NULL)
}
\arguments{
\item{method}{Mandatory character value. Value must be upper case.}

\item{req.url}{THE URL component for the API. Default to "/accounts".}

\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}

\item{order}{Optional named list. If method is \code{POST} then the field is required for post to work, else the api end point will return an error.}
}
\value{
A named list of server response.
}
\description{
This is an internal function that will be used for all private connections to the user account. This function determines the kind of GDAX call (GET / POST / DELETE).
}
