% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_order.R
\name{cancel_order}
\alias{cancel_order}
\title{Cancel Pending Orders}
\usage{
cancel_order(order_id = "all", api.key, secret, passphrase)
}
\arguments{
\item{order_id}{Optional character value. This is the order id as generated by GDAX.}

\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}
}
\value{
A Dataframe of order-ids of all orders that were cancelled.
}
\description{
This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The users can cancel all orders pending except stop orders (GDAX does not treat STOP order as an open order unless the stop price is kicked in). User can now pass an optional order id to cancel a specific order including stop orders. Open orders can now be determined with \code{\link{open_orders}}
}
\examples{
\dontrun{
cancel_order(api.key = your_key,
             secret = your_api_secret,
             passphrase = your_api_pass)

cancel_order(order_id = "a0a00000-0000-000a-a000-a0a0aa00000a",
             api.key = your_key,
             secret = your_api_secret,
             passphrase = your_api_pass)
}
}
