% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_extract.R
\name{ee_extract}
\alias{ee_extract}
\title{Extract values from EE Images or ImageCollections objects}
\usage{
ee_extract(
  x,
  y,
  fun = ee$Reducer$mean(),
  scale = NULL,
  sf = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{ee$Image.}

\item{y}{ee$Geometry$*, ee$Feature, ee$FeatureCollection, sfc or sf objects.}

\item{fun}{ee$Reducer object. Function to summarize the values. The function
must take a single numeric value as an argument and return a single value.
See details.}

\item{scale}{A nominal scale in meters of the Image projection to work in.
By default 1000.}

\item{sf}{Logical. Should return a sf object?}

\item{quiet}{Logical. Suppress info message.}

\item{...}{ee$Image$reduceRegions additional parameters. See
\code{ee_help(ee$Image$reduceRegions)} for more details.}
}
\value{
A data.frame or an sf object depending on the sf argument.
Column names are extracted from band names, use \code{ee$Image$rename} to
rename the bands of an \code{ee$Image}. See \code{ee_help(ee$Image$rename)}.
}
\description{
Extract values from a \code{ee$Image} at the
locations of a geometry object. You can use \code{ee$Geometry$*},
\code{ee$Feature}, \code{ee$FeatureCollection}, sf  or sfc objects. This function
mimicking how \link[raster]{extract} currently works.
}
\details{
The reducer functions that return one value are:
\itemize{
\item  \strong{allNonZero}: Returns a Reducer that returns 1 if all of its
inputs are non-zero, 0 otherwise. \cr
\item \strong{anyNonZero}: Returns a Reducer that returns 1 if any of its
inputs are non-zero, 0 otherwise. \cr
\item \strong{bitwiseAnd}: Returns a Reducer that computes the bitwise-and
summation of its inputs.
\item \strong{bitwiseOr}: Returns a Reducer that computes the bitwise-or
summation of its inputs.
\item \strong{count}: Returns a Reducer that computes the number of
non-null inputs.
\item \strong{first}: Returns a Reducer that returns the first of its inputs.
\item \strong{firstNonNull}: Returns a Reducer that returns the first of
its non-null inputs.
\item \strong{kurtosis}: Returns a Reducer that Computes the kurtosis of
its inputs.
\item \strong{last}: Returns a Reducer that returns the last of its inputs.
\item \strong{lastNonNull}: Returns a Reducer that returns the last of its
non-null inputs.
\item \strong{max}: Creates a reducer that outputs the maximum value of
its (first) input. If numInputs is greater than one, also outputs the
corresponding values of the additional inputs.
\item \strong{mean}: Returns a Reducer that computes the (weighted)
arithmetic mean of its inputs.
\item \strong{median}: Create a reducer that will compute the median of
the inputs. For small numbers of inputs (up to maxRaw) the median will be
computed directly; for larger numbers of inputs the median will be derived
from a histogram.
\item \strong{min}: Creates a reducer that outputs the minimum value
of its (first) input.  If numInputs is greater than one, also outputs
additional inputs.
\item \strong{mode}: Create a reducer that will compute the mode of the
inputs.  For small numbers of inputs (up to maxRaw) the mode will be
computed directly; for larger numbers of inputs the mode will be derived
from a histogram.
\item \strong{product}: Returns a Reducer that computes the product of
its inputs.
\item \strong{sampleStdDev}: Returns a Reducer that computes the sample
standard deviation of its inputs.
\item \strong{sampleVariance}: Returns a Reducer that computes the sample
variance of its inputs.
\item \strong{stdDev}: Returns a Reducer that computes the standard
deviation of its inputs.
\item \strong{sum}: Returns a Reducer that computes the (weighted) sum
of its inputs.
\item \strong{variance}: Returns a Reducer that computes the variance
of its inputs.
}
}
\examples{
\dontrun{
library(rgee)
library(sf)

ee_Initialize()

# Define a Image or ImageCollection: Terraclimate
terraclimate <- ee$ImageCollection("IDAHO_EPSCOR/TERRACLIMATE") \%>\%
  ee$ImageCollection$filterDate("2001-01-01", "2002-01-01") \%>\%
  ee$ImageCollection$map(
    function(x) {
      date <- ee$Date(x$get("system:time_start"))$format('YYYY_MM_dd')
      name <- ee$String$cat("Terraclimate_pp_", date)
      x$select("pr")$rename(name)
    }
  )

# Define a geometry
nc <- st_read(
  dsn = system.file("shape/nc.shp", package = "sf"),
  stringsAsFactors = FALSE,
  quiet = TRUE
)


# Extract values

ee_nc_rain <- ee_extract(
  x = terraclimate,
  y = nc,
  scale = 250,
  fun = ee$Reducer$mean(),
  sf = TRUE
)

# Spatial plot
plot(
  ee_nc_rain["Terraclimate_pp_2001_11_01"],
  main = "2001 Jan Precipitation - Terraclimate",
  reset = FALSE
)
}
}
