% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComByCode.R
\name{ComByCode}
\alias{ComByCode}
\title{Get City by INSEE Code}
\usage{
ComByCode(codeInsee, postal = FALSE)
}
\arguments{
\item{codeInsee}{numeric vector with an INSEE code.}

\item{postal}{wether or not to include postal codes. Default is FALSE.}
}
\value{
Returns a data.frame with names, INSEE code, postal code, INSEE department code, INSEE region code, population (approx), surface (in hectares), lat and long (WGS-84).
}
\description{
Get informations about a French city by its INSEE code. Please note that this package works only with French cities.
}
\details{
Takes an INSEE Code, returns a data.frame with the available values.
}
\note{
If you don't know the INSEE code of the city you're looking for, you can find it by using the \code{\link{ComByName}} function.
}
\examples{
ComByCode(codeInsee = 29019) 
ComByCode(codeInsee = 31555, postal = TRUE)
ComByCode(codeInsee = ComByName("Rennes")[1,"codeInsee"])
}

