% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_quantilelisa}
\alias{local_quantilelisa}
\title{Quantile LISA Statistics}
\usage{
local_quantilelisa(
  w,
  k,
  q,
  data,
  permutations = 999,
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{k}{A value indicates the number of quantiles. Value range e.g. [1, 10]}

\item{q}{A value indicates which quantile or interval used in local join count statistics. Value stars from 1.}

\item{data}{A numeric array of selected variable}

\item{permutations}{The number of permutations for the LISA computation}

\item{significance_cutoff}{A cutoff value for significance p-values to filter not-significant clusters}

\item{cpu_threads}{The number of cpu threads used for parallel LISA computation}

\item{seed}{The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply quantile LISA statistics
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1]
lisa <- local_quantilelisa(queen_w, k=4, q=1, crm_prs)
clsts <- lisa_clusters(lisa)
clsts
}
