% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hinge15_breaks}
\alias{hinge15_breaks}
\title{(Box) Hinge15 Breaks}
\usage{
hinge15_breaks(df)
}
\arguments{
\item{df}{A data frame with selected variable. E.g. guerry["Crm_prs"]}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Hinge15 breaks data into 6 groups like box plot groups
(Lower outlier, < 25%, 25-50%, 50-75%, >75%, Upper outlier) with hinge=1.5
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
hinge15_breaks(guerry['Crm_prs'])
}
