% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/freegeoip.R
\name{freegeoip}
\alias{freegeoip}
\title{Geolocate IP Addresses Through freegeoip.net}
\usage{
freegeoip(ip_addresses, as_data_frame = TRUE)
}
\arguments{
\item{ip_addresses}{a character vector of IP addresses}

\item{as_data_frame}{whether to return the results as a data.frame or not.
Set to TRUE by default.}
}
\value{
either a data.frame or a list of vectors. If an IP cannot be geolocated, it
will provide an error message: see the examples for field names and examples of each
possible output.
}
\description{
\code{freegeoip} consumes a vector of IP addresses
and geolocates them via \href{http://freegeoip.net}{freegeoip.net}.
}
\examples{
\dontrun{
#Valid, data.frame output
result <- freegeoip("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93")

#Invalid, data.frame output
result <- freegeoip("argh")

#Valid list output
result <- freegeoip("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93", as_data_frame = FALSE)

#Invalid list output
result <- freegeoip("argh", as_data_frame = FALSE)
}
}

