% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognorm_profile.R
\name{lognorm_profile}
\alias{lognorm_profile}
\title{CrimeStat Lognormal Model for Geographic Profiling}
\usage{
lognorm_profile(lat, lon, a = NULL, d_mean = NULL, sd = NULL, n = NULL)
}
\arguments{
\item{lat}{a vector of latitudes for the crime incident series}

\item{lon}{a vector of latitudes for the crime incident series}

\item{a}{coefficient for the normal decay function. If \code{NULL}, the default
value for 'a' is 8.6 (Levine 2013)}

\item{d_mean}{mean distance. If \code{NULL}, the default value for 'd_mean' is
4.2 (Levine 2013)}

\item{sd}{standard deviation of the distances. If \code{NULL}, the default
value for 'sd' is 4.6 (Levine 2013)}

\item{n}{total number of cells within the spatial grid for the jeopardy surface.
If \code{NULL}, the default value for '*n*' is 40,000.}
}
\value{
A data frame of points depicting a spatial grid of the hunting area
    for the given incident locations. Also given are the resultant summed
    values (score) for each map point. A higher resultant score indicates
    a greater the probability that point contains the offender's anchor point.
}
\description{
An implementation of the lognormal decay model for serial crime
    analysis within 'CrimeStat'. This model is very similar to the normal model
    except with more skew to either side. If there is reason to believe that
    the perpetrator's residence is closer to the incidents, this function can
    take the form of a very rapid increase near incident with a gradual decline
    from the peak likelihood.
}
\examples{
\dontshow{
data(desalvo)
test <- lognorm_profile(desalvo$lat, desalvo$lon, n = 4)
}
\donttest{
#Using provided dataset for the Boston Strangler Incidents:
data(desalvo)
test <- lognorm_profile(desalvo$lat, desalvo$lon)
g_map = sp::SpatialPixelsDataFrame(points = test[c("lons", "lats")], data = test)
g_map <- raster::raster(g_map)
# Assign a Coordinate Reference System for the Raster
raster::crs(g_map) <- sp::CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
# Define a Parula Color Pallete for Resultant Jeopardy Surface
library(leaflet) #for mapping the geographic profile
pal <- colorNumeric(pals::parula(200), raster::values(g_map),
    na.color = "transparent")
leaflet() \%>\%
    addTiles() \%>\%
    addProviderTiles('Esri.WorldTopoMap', group = 'Topo') \%>\%
    addAwesomeMarkers(lng = -71.07357, lat = 42.41322, icon =
        awesomeIcons(icon = 'home', markerColor = 'green'), popup = 'Residence') \%>\%
    addRasterImage(g_map, colors = pal, opacity = 0.6) \%>\%
    addLegend(pal = pal, values = raster::values(g_map), title = 'Score') \%>\%
    addCircleMarkers(lng = desalvo$lon, lat = desalvo$lat, radius = 4, opacity = 1,
        fill = 'black', stroke = TRUE, fillOpacity = 0.75, weight = 2,
        fillColor = "red")
}
}
\references{
Ned Levine, \emph{CrimeStat IV: A Spatial Statistics Program for the
    Analysis of Crime Incident Locations (version 4.0)}. Ned Levine & Associates,
    Houston, TX, and the National Institute of Justice, Washington, DC, June 2013.
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{methods}
\keyword{spatial}
