% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_ad_group_criterions.R
\name{gads_get_ad_group_criterions}
\alias{gads_get_ad_group_criterions}
\title{Get Ad Group Criterions Dictionary From Google Ads Client Account}
\usage{
gads_get_ad_group_criterions(
  customer_id = getOption("gads.customer.id"),
  fields = c("ad_group_criterion.ad_group", "ad_group_criterion.age_range.type",
    "ad_group_criterion.app_payment_model.type", "ad_group_criterion.approval_status",
    "ad_group_criterion.bid_modifier",
    "ad_group_criterion.combined_audience.combined_audience",
    "ad_group_criterion.cpc_bid_micros", "ad_group_criterion.cpm_bid_micros",
    "ad_group_criterion.cpv_bid_micros", "ad_group.id", "customer.id",
    "customer.descriptive_name", "ad_group_criterion.criterion_id",
    "ad_group_criterion.custom_affinity.custom_affinity", 
    
    "ad_group_criterion.custom_audience.custom_audience",
    "ad_group_criterion.custom_intent.custom_intent",
    "ad_group_criterion.disapproval_reasons", "ad_group_criterion.display_name",
    "ad_group_criterion.effective_cpc_bid_micros",
    "ad_group_criterion.effective_cpc_bid_source",
    "ad_group_criterion.effective_cpm_bid_micros",
    "ad_group_criterion.effective_cpm_bid_source",
    "ad_group_criterion.effective_cpv_bid_micros",
    "ad_group_criterion.effective_cpv_bid_source",
    "ad_group_criterion.effective_percent_cpc_bid_micros", 
    
    "ad_group_criterion.effective_percent_cpc_bid_source",
    "ad_group_criterion.final_mobile_urls", "ad_group_criterion.final_url_suffix",
    "ad_group_criterion.final_urls", "ad_group_criterion.gender.type",
    "ad_group_criterion.income_range.type", "ad_group_criterion.keyword.match_type",
    "ad_group_criterion.keyword.text", "ad_group_criterion.labels",
    "ad_group_criterion.listing_group.case_value.hotel_city.city_criterion",
    "ad_group_criterion.listing_group.case_value.hotel_class.value",
    "ad_group_criterion.listing_group.case_value.hotel_id.value", 
    
    "ad_group_criterion.listing_group.case_value.hotel_state.state_criterion",
    "ad_group_criterion.listing_group.case_value.product_bidding_category.country_code",
    "ad_group_criterion.listing_group.case_value.product_bidding_category.id",
    "ad_group_criterion.listing_group.case_value.product_bidding_category.level",
    "ad_group_criterion.listing_group.case_value.product_brand.value",
    "ad_group_criterion.listing_group.case_value.product_channel.channel",
    "ad_group_criterion.listing_group.case_value.product_condition.condition", 
    
    "ad_group_criterion.listing_group.case_value.product_custom_attribute.index",
    "ad_group_criterion.listing_group.case_value.product_custom_attribute.value",
    "ad_group_criterion.listing_group.case_value.product_type.level",
    "ad_group_criterion.listing_group.case_value.product_item_id.value",
    "ad_group_criterion.listing_group.case_value.product_type.value",
    "ad_group_criterion.listing_group.parent_ad_group_criterion",
    "ad_group_criterion.listing_group.type",
    "ad_group_criterion.mobile_app_category.mobile_app_category_constant", 
    
    "ad_group_criterion.mobile_application.app_id",
    "ad_group_criterion.mobile_application.name", "ad_group_criterion.negative",
    "ad_group_criterion.parental_status.type",
    "ad_group_criterion.percent_cpc_bid_micros", "ad_group_criterion.placement.url",
    "ad_group_criterion.position_estimates.estimated_add_cost_at_first_position_cpc",
    "ad_group_criterion.position_estimates.estimated_add_clicks_at_first_position_cpc",
    "ad_group_criterion.position_estimates.first_page_cpc_micros",
    "ad_group_criterion.position_estimates.first_position_cpc_micros", 
    
    "ad_group_criterion.position_estimates.top_of_page_cpc_micros",
    "ad_group_criterion.quality_info.creative_quality_score",
    "ad_group_criterion.quality_info.post_click_quality_score",
    "ad_group_criterion.quality_info.quality_score",
    "ad_group_criterion.quality_info.search_predicted_ctr",
    "ad_group_criterion.resource_name", "ad_group_criterion.status",
    "ad_group_criterion.system_serving_status", "ad_group_criterion.topic.path",
    "ad_group_criterion.topic.topic_constant",
    "ad_group_criterion.tracking_url_template", 
     "ad_group_criterion.type",
    "ad_group_criterion.url_custom_parameters",
    "ad_group_criterion.user_interest.user_interest_category",
    "ad_group_criterion.user_list.user_list", "ad_group_criterion.webpage.conditions",
    "ad_group_criterion.webpage.coverage_percentage",
    "ad_group_criterion.webpage.criterion_name",
    "ad_group_criterion.webpage.sample.sample_urls",
    "ad_group_criterion.youtube_channel.channel_id",
    "ad_group_criterion.youtube_video.video_id"),
  where = NULL,
  order_by = NULL,
  limit = NULL,
  parameters = NULL,
  login_customer_id = getOption("gads.login.customer.id"),
  include_resource_name = FALSE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{fields}{character vector, list of report fields, all report has own fields list, for example \href{https://developers.google.com/google-ads/api/fields/v10/ad_group}{see field list of ad group report}.}

\item{where}{Filter, for example you can filter campaigns by status \code{where = "campaign.status = 'ENABLED'"}.}

\item{order_by}{Sorting, character vectors of fields and sorting directions, for example \code{order_by = c("campaign.name DESC", "metrics.clicks")}.}

\item{limit}{Maximun rows in report}

\item{parameters}{Query parameters, for example \code{parameters = "include_drafts=true"}.}

\item{login_customer_id}{Google Ads manager customer id}

\item{include_resource_name}{Get resource names fields in report}

\item{cl}{A cluster object created by \code{\link{makeCluster}}, or an integer to indicate number of child-processes (integer values are ignored on Windows) for parallel evaluations (see Details on performance).}

\item{verbose}{Console log output}
}
\value{
tibble with ad group criterions dicrionary
}
\description{
Get Ad Group Criterions Dictionary From Google Ads Client Account
}
\examples{
\dontrun{
# set client customer id
gads_set_login_customer_id('xxx-xxx-xxxx')

# set manager id if you work under MCC
gads_set_customer_id('xxx-xxx-xxxx')

# load ad groups keywords list
kw <- gads_get_ad_group_criterions()

}
}
\seealso{
\href{https://developers.google.com/google-ads/api/fields/v10/ad_group_criterion_query_builder}{Google Ads Query Builder}
}
