\name{xyplot.eda7}
\alias{xyplot.eda7}
\title{ Display a Third Variable in a X-Y Plot using Tukey Boxplot Symbology }
\description{
Displays a third variable where the data are represented by symbols using Tukey boxplot-based symbology. Tukey boxplots divide data into 7 groups, the middle 50\%, and three lower and higher groupings, see Details below. The computation of the fences used to subdivide the data may be carried out following a logarithmic transformation of the data. The colours of the symbols may be optionally changed.
}
\usage{
xyplot.eda7(xx, yy, zz, sfact = 1, xlim = NULL, ylim = NULL,  
	log = NULL, logz = FALSE, xlab = deparse(substitute(xx)), 
	ylab = deparse(substitute(yy)), zlab = deparse(substitute(zz)), 
	main = "", ifgrey = FALSE, symcolr = NULL, ...)
}
\arguments{
  \item{xx}{ name of the x-axis variable. }
  \item{yy}{ name of the y-axis variable. }
  \item{zz}{ name of the third variable to be plotted. }
  \item{sfact}{ controls the absolute size of the plotted symbols, by default \code{sfact = 1}.  Increasing sfact results in larger symbols. }
  \item{xlim}{ user defined limits for the x-axis, see Details below. }
  \item{ylim}{ user defined limits for the y-axis, see Details below. }
  \item{log}{ if it is required to display the data with logarithmic axis scaling, set \code{log = "x"} for a logarithmicly scaled x-axis, \code{log = "y"} for a logarithmicly scaled y-axix, and \code{log = "xy"} for both axes logarithmicly scaled. }
  \item{logz}{ if it is required to undertake the Tukey Boxplot computations after a logarithmic data transform, set \code{logz = TRUE}. }
  \item{xlab}{ the x-axis title, by default the variable name, \code{deparse(substitute(xx))}. It is often desirable to replace the default x-axis title of the input variable name text string with a more informative title, e.g., \code{xlab = "Fe (mg/kg) in stream sediment"}. }
  \item{ylab}{ the y-axis title, by default the variable name, \code{deparse(substitute(yy))}. It is often desirable to replace the default y-axis title of the input variable name text string with a more informative title, e.g., \code{ylab = "Mn (mg/kg) in stream sediment"}. }
  \item{zlab}{ by default, \code{zlab = deparse(substitute(zz))}, a plot title is generated by appending the input variable name text string to \dQuote{Proportional Symbol Map for}. Alternative titles may be generated, see Details below. }
  \item{main}{ an alternative plot title, see Details below.}
  \item{ifgrey}{ set \code{ifgrey = TRUE} if a grey-scale plot is required, see Details below. }
  \item{symcolr}{ the default is a colour plot and default colours are provided, deeper blues for lower values, green for the middle 50\% of the data, and oranges and reds for higher values.  A set of alternate symbol colours can be provided by defining \code{symcolr}, see Details below. }
  \item{\dots}{ further arguments to be passed to methods.  For example, if it is required to make the plot title smaller, add \code{cex.main = 0.9} to reduce the font size by 10\%. }
}
\details{
Tukey boxplots divide data into 7 groups, the middle 50\%, and three lower and high groupings: within the whisker, near outliers and far outliers, respectively.  Symbols for values below the first quartile (Q1) are plotted as increasingly larger circles, while symbols for values above the third quartile are plotted as increasingly larger squares.  For the higher groupings, the whisker contains values \code{>Q3 and <(Q3 + 1.5 * HW)}, where \code{HW = (Q3 - Q1)}, the interquartile range; near outliers lie between \code{(Q3 + 1.5 * HW)} and \code{(Q3 + 3 * HW)}; and far outliers have values \code{>(Q3 + 3 * HW)}.  For the lower groupings the group boundaries, fences, fall similarly spaced below Q1.  The computation of the fences used to subdivide the data may be carried out following a logarithmic transformation of the data, set \code{logz = TRUE}.

A summary table of the values of the symbol intervals, the number of values plotting as each symbol, and symbol shapes, sizes and colours is displayed on the current device.

If \code{zlab} and \code{main} are undefined a default a plot title is generated by appending the input variable name text string to \dQuote{EDA Tukey Boxplot-Based Plot for}.  If no plot title is required set \code{zlab = ""}, and if some user defined plot title is required it should be defined in \code{main}, e.g. \code{main = "Plot Title Text"}.

If the grey-scale option is chosen the symbols are plotted 100\% black for the far outliers, 85\% black for the near outliers, 70\% black for values within the whiskers, and 60\% black for values falling within the middle 50\% of the data.

The default colours, \code{symcolr = c(25, 22, 20, 13, 6, 4, 1)}, are selected from the \code{rainbow(36)} pallette, and alternate colour schemes need to be selected from the same palette.  See \code{\link{display.rainbow}} for the available colours.  It is essential that 7 colours be provided, e.g., \code{symcolr = c(27, 24, 22, 12, 5, 3, 36)}, if exactly 7 are not provided the default colours will be displayed.
}
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data vector, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any \code{NA}s in the data vector are removed prior to displaying the plot.
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{display.rainbow}}, \code{\link{ltdl.fix.df}}, \code{\link{remove.na}} }
\examples{
## Make test data available
data(sind)
attach(sind)

## Plot a default Tukey boxplot-based display
xyplot.eda7(Fe, Mn, Zn)

## Plot with logarithmically scaled boxplot fences and more
## appropriate axis scaling and labelling with a user specified title
xyplot.eda7(Fe, Mn, Zn, sfact = 2, log = "y", logz = TRUE,
	xlab = "Fe (pct) in stream sediment", 
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data") 

## Display a grey-scale equivalent of the above plot
xyplot.eda7(Fe, Mn, Zn, sfact = 2, log = "y", logz = TRUE, ifgrey = TRUE,
	xlab = "Fe (pct) in stream sediment", 
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data") 

## Plot the same display with an alternate colour scheme
xyplot.eda7(Fe, Mn, Zn, sfact = 2, log = "y", logz = TRUE,
	xlab = "Fe (pct) in stream sediment", 
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data",
	symcolr = c(27, 24, 22, 12, 5, 3, 36)) 

## Detach test data
detach(sind)
}
\keyword{ hplot }

