\name{gx.md.display}
\alias{gx.md.display}
\title{ Function to Display Membership Probabilities and Other Relevant Data }
\description{
Function to display the Mahalanobis distances (MDs) and predicted probabilities of membership (ppm), together with other relevant data, following computations by functions \code{\link{gx.md.gait}}, \code{\link{gx.md.gait.closed}}, \code{\link{gx.mva}}, \code{\link{gx.robmva}}, or \code{\link{gx.robmva.closed}}.  The user may select the predicted probability of membership below which the results are displayed.  A simpler presentation is available with \code{\link{gx.md.print}}.  Optionally the entire generated table may be saved as a \sQuote{.csv} file for future use. 
}
\usage{
gx.md.display(xx, pcut = 0.1, file = NULL)
}
\arguments{
  \item{xx}{ the data to be displayed in a \code{cbind} construct, see Details below. }
  \item{pcut}{ the probabilitity of group membership below which records will be displayed on the current device in ascending order of membership probability, i.e. most outlying individuals first. }
  \item{file}{ the file name for saving the function output in the R working directory, see Details below. }
}
\details{
The data frame from which the matrices were derived from for use by the above listed functions must be attached if such items as sample IDs, coordinates and data values are to be displayed.  Those items and/or variables to be displayed must be appended in a \code{cbind} construct following the \sQuote{MDs} and \sQuote{ppms} extracted from the saved objects from the above listed functions.  For example, \code{cbind(save.sind$md, save.sind$ppm, ID, Zn, Cu, Cd, Fe, Mn)}.  The table generated by the function may be saved as a \sQuote{csv} file in the working directory.  Note, the \sQuote{.csv} extension is appended in the function.  See example below.
}
\value{
The displayed table, \code{table.rows}, is returned and may be saved as an object if required.  It will contain the information passed to the function as \code{xx} sorted by MD and with appropriate column headings.
}
\note{
This function is similar in purpose to \code{\link{gx.mvalloc.print}} for displaying multivariate outliers, however, it operates on a single population. 
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{gx.md.gait}}, \code{\link{gx.md.gait.closed}}, \code{\link{gx.mva}}, \code{\link{gx.robmva}}, \code{\link{gx.robmva.closed}}, \cr\code{\link{gx.mvalloc}}, \code{\link{gx.mvalloc.print}}, \code{\link{gx.md.print}}. } 
\examples{
## Make test data available
data(sind.mat2open)
data(sind)
attach(sind)
## data frame sind attached to provide access to row IDs

## Estimate and display robust Mahalanobis distances
sind.save <- gx.md.gait.closed(sind.mat2open, mcdstart = TRUE, ifadd = NULL)
gx.md.display(cbind(sind.save$md, sind.save$ppm, ID, Zn, Cu, Cd, Fe, Mn),
pcut = 0.3)

## Save display for future use
gx.md.display(cbind(sind.save$md, sind.save$ppm, ID, Zn, Cu, Cd, Fe, Mn),
file = "sind.save.ilr.mds")

## Clean-up
rm(sind.save)
detach(sind)
}
\keyword{ print }

