gx.robmva.closed <-
function (xx, proc = "mcd", wts = NULL, main = deparse(substitute(xx))) 
{
    if (!is.matrix(xx)) 
        stop(deparse(substitute(xx)), " is not a Matrix")
    temp.x <- remove.na(xx)
    x <- temp.x$x
    n <- temp.x$n
    p <- temp.x$m
    matnames <- dimnames(xx)
    matnames[[1]] <- c(1:n)
    x.ilr <- ilr(x)
    if (is.null(wts)) {
        if (p > 50) 
            proc <- "mve"
        if (proc == "mve") {
            save.ilr <- cov.mve(x.ilr, cor = TRUE)
            wts <- array(0, n)
            wts[save.ilr$best] <- 1
        }
        else {
            save.ilr <- cov.mcd(x.ilr, cor = TRUE)
            wts <- array(0, n)
            wts[save.ilr$best] <- 1
        }
    }
    else {
        if (length(wts) != n) 
            stop(paste("Length of vector wts, ", length(wts), 
                ", must be equal to the number of individuals, ", 
                n, "\n  Were any individuals with NAs removed by the function?", 
                sep = ""), call. = FALSE)
        proc <- "wts"
        save.ilr <- cov.wt(x.ilr, wt = wts, cor = TRUE)
    }
    nc <- sum(wts)
    cat("  n = ", n, "\tnc = ", nc, "\tp = ", p, "\t\tnc/p = ", 
        round(nc/p, 2), "\n")
    if (nc < 5 * p) 
        cat("  *** Proceed with Care, Core Size is < 5p ***\n")
    if (nc < 3 * p) 
        cat("  *** Proceed With Great Care, nc = ", nc, ", which is < 3p ***\n")
    md <- mahalanobis(x.ilr, save.ilr$center, save.ilr$cov)
    p.ilr <- p - 1
    temp <- (nc - p.ilr)/(p.ilr * (nc + 1))
    ppm <- 1 - pf(temp * md, p.ilr, nc - p.ilr)
    epm <- 1 - pchisq(md, p.ilr)
    inverted <- ginv(save.ilr$cov)
    V <- orthonorm(p)
    cov.clr <- V %*% save.ilr$cov %*% t(V)
    dimnames(cov.clr)[[1]] <- dimnames(cov.clr)[[2]] <- matnames[[2]]
    inverted.clr <- V %*% inverted %*% t(V)
    dimnames(inverted.clr) <- dimnames(cov.clr)
    corr <- V %*% save.ilr$cor %*% t(V)
    dimnames(corr) <- dimnames(cov.clr)
    center <- as.vector(save.ilr$center %*% t(V))
    sd <- sqrt(diag(cov.clr))
    names(center) <- names(sd) <- matnames[[2]]
    x <- x.ilr %*% t(V)
    dimnames(x) <- matnames
    temp <- sweep(x, 2, center, "-")
    snd <- sweep(temp, 2, sd, "/")
    b <- svd(corr)
    cat("  Eigenvalues:", signif(b$d, 4), "\n")
    sumc <- sum(b$d)
    econtrib <- 100 * (b$d/sumc)
    b1 <- b$v * 0
    diag(b1) <- sqrt(b$d)
    rload <- b$v %*% b1
    rqscore <- snd %*% rload
    cpvcontrib <- pvcontrib <- vcontrib <- numeric(p)
    for (j in 1:p) vcontrib[j] <- var(rqscore[, j])
    sumv <- sum(vcontrib)
    pvcontrib <- (100 * vcontrib)/sumv
    cpvcontrib <- cumsum(pvcontrib)
    rcr <- rload[, ] * 0
    rcr1 <- apply(rload^2, 1, sum)
    rcr <- 100 * sweep(rload^2, 1, rcr1, "/")
    dimnames(rload)[[1]] <- dimnames(rcr)[[1]] <- matnames[[2]]
    invisible(list(main = main, input = deparse(substitute(xx)), 
        proc = proc, n = n, nc = nc, p = p, ifilr = TRUE, matnames = matnames, 
        wts = wts, mean = center, cov = cov.clr, cov.inv = inverted.clr, 
        sd = sd, snd = snd, r = corr, eigenvalues = b$d, econtrib = econtrib, 
        eigenvectors = b$v, rload = rload, rcr = rcr, rqscore = rqscore, 
        vcontrib = vcontrib, pvcontrib = pvcontrib, cpvcontrib = cpvcontrib, 
        md = md, ppm = ppm, epm = epm, nr = NULL))
}
