% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_as_text.R
\name{graph_as_text}
\alias{graph_as_text}
\alias{graph_as_text.default}
\alias{graph_as_text.list}
\title{Encode graph as text}
\usage{
graph_as_text(object, ...)

\method{graph_as_text}{default}(object, ...)

\method{graph_as_text}{list}(object, ...)
}
\arguments{
\item{object}{igraph/network object or a list thereof}

\item{...}{other arguments, currently ignored}
}
\value{
A character vector of encoded graphs.
}
\description{
Encode a graph as 'graph6', 'sparse6' or 'digraph6' choosing the format
automatically.
}
\details{
If \code{object} is a list it may be a mixture of 'network' and 'igraph'
objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{graph_as_text(default)}: The default method chooses the encoding format
automatically using \code{\link[=choose_format]{choose_format()}}.

\item \code{graph_as_text(list)}: The list method applies the default method to each
element.

}}
\examples{
# From igraph ------------------------------------------------------
if(requireNamespace("igraph")) {
   g <- igraph::graph.famous("Zachary")
   graph_as_text(g)
   
   glist <- list(
      igraph::sample_gnp(n = 15,p = 0.1),
      igraph::sample_gnp(n = 15,p = 0.2), 
      igraph::sample_gnp(n = 15,p = 0.3))
      
   graph_as_text(glist)
}

# From network -----------------------------------------------------
if(requireNamespace("network")) {
   m <- matrix(rbinom(25,1,.4),5,5)
   diag(m) <- 0
   g <- network::network(m, directed=FALSE)
   graph_as_text(g)
}
}
\seealso{
\code{\link[=choose_format]{choose_format()}}
}
