% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{AffinityPropagation}
\alias{AffinityPropagation}
\title{Performs clustering according to the affinity propagation algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.AffinityPropagation.html#sklearn.cluster.AffinityPropagation}{sklearn.cluster.AffinityPropagation}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- AffinityPropagation$new()
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Brendan J. Frey and Delbert Dueck (2007). \emph{Clustering by Passing Messages
Between Data Points}, Science.
}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{AffinityPropagation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AffinityPropagation-new}{\code{AffinityPropagation$new()}}
\item \href{#method-AffinityPropagation-clone}{\code{AffinityPropagation$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AffinityPropagation-new"></a>}}
\if{latex}{\out{\hypertarget{method-AffinityPropagation-new}{}}}
\subsection{Method \code{new()}}{
The \link{AffinityPropagation} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AffinityPropagation$new(
  damping = 0.5,
  max_iter = 200L,
  convergence_iter = 15L,
  copy = TRUE,
  preference = NULL,
  affinity = c("euclidean", "precomputed"),
  verbose = FALSE,
  random_state = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{damping}}{A numeric value specifying the damping factor in the range
\eqn{[0.5, 1.0)} which is the extent to which the current value is
maintained relative to incoming values (weighted \code{1 - damping}). This
avoids numerical oscillations when updating these values (messages).
Defaults to \code{0.5}.}

\item{\code{max_iter}}{An integer value specifying the maximum number of
iterations. Defaults to \code{200L}.}

\item{\code{convergence_iter}}{An integer value specifying the number of
iterations with no change in the number of estimated clusters that
stops the convergence. Defaults to \code{15L}.}

\item{\code{copy}}{A boolean value specifying whether to make a copy of input
data. Defaults to \code{TRUE}.}

\item{\code{preference}}{A numeric value or numeric vector specifying the
preferences for each point. Points with larger values of preferences
are more likely to be chosen as exemplars. The number of exemplars,
i.e. of clusters, is influenced by the input preferences value. If the
preferences are not passed as arguments, they will be set to the median
of the input similarities. Defaults to \code{NULL}.}

\item{\code{affinity}}{A string specifying the affinity to use. At the moment
\code{"precomputed"} and \code{"euclidean"} are supported. \code{"euclidean"} uses the
negative squared euclidean distance between points. Defaults to
\code{"euclidean"}.}

\item{\code{verbose}}{A boolean value specifying whether to be verbose. Defaults
to \code{FALSE}.}

\item{\code{random_state}}{An integer value specifying the seed of the random
generator. Defaults to \code{NULL} which uses current time. Set it to a
fixed integer for reproducible results across function calls.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{AffinityPropagation}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AffinityPropagation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AffinityPropagation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AffinityPropagation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
