% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodb_download.R
\name{geodb_download}
\alias{geodb_download}
\title{Download General Geographic Databases for entire voivodeships}
\usage{
geodb_download(voivodeships, outdir = ".", unzip = TRUE, ...)
}
\arguments{
\item{voivodeships}{selected voivodeships in Polish or English, or TERC
(object \code{\link{voivodeship_names}} can by helpful)}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
a database in Geography Markup Language format (.GML),
the content and detail level corresponds to the general
geographic map in the scale of 1:250000
}
\description{
Download General Geographic Databases for entire voivodeships
}
\examples{
\dontrun{
geodb_download(c("opolskie", "lubuskie")) # 12.7 MB
geodb_download(c("Opole", "Lubusz")) # 12.7 MB
geodb_download(c("16", "08")) # 12.7 MB
}
}
\references{
description of topographical and general geographical databases,
and technical standards for making maps (in Polish):
\url{https://isap.sejm.gov.pl/isap.nsf/download.xsp/WDU20210001412/O/D20211412.pdf}

brief description of categories and layer names (in English and Polish):
\url{https://kadyb.github.io/rgugik/articles/articles/spatialdb_description.html}
}
