\name{rhcoclust_internet}
\alias{rhcoclust_internet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Interaction network (internet) of the 'rhcoclust' objects
}
\description{
This function is used for visualization of clustering interaction network plot for the objects that are generated by rhcoclust and list of up-regulated and down-regulated variables list. There are three layers in the network plot, (i) genes (rows) are shown in the first layer, (ii) co-cluster are in the second layer and (iii) columns (compounds) are in the last layer. Red and blue color indicates up and down regulated respectively.
}
\usage{
rhcoclust_internet(data, CoClustObj, plot.internet = FALSE)
}
\arguments{
  \item{data}{A data matrix containing data having the characteristics of interval and ratio level of measurement or continuous data}
    \item{CoClustObj}{A list of output objects from rhcoclust}
    \item{plot.internet}{To set no plotting as the default for interaction network (internet) }
}

\value{
Plot
A \link{list} up-regulated and down-regulated variables.

}

\author{
Md. Bahadur Badsha <mbbadshar@gmail.com>
}

\seealso{
\link{rhcoclust} for generating a graph objects for clustering network
}
\examples{
# Load necessary library
library(rhcoclust)
library(fields)

# Load real data
data("toxygates_data")

# Load predefined simulated data
data("simu_data")

# Data analysis using real data by rhcoclust. Note, for analysis of predefined
# simulated data
data <- simu_data
# Real data use: data <- toxygates_data

# Apply rhcoclust to identify significant co-cluster of samples and their regulatory features
CoClustObj <- rhcoclust(data, rk=4, ck=3, method.dist = "manhattan", method.hclust = "ward.D")

# Plot interaction network (internet)
# use dev.off() to avoid the figure margin from previous plot
# mar order: bottom, left, top, and right
# par(mar=c(5,2,5,2)) # please modify when necessary to best fit for the plot
rhcoclust_internet(data, CoClustObj = CoClustObj, plot.internet = TRUE)

}
